% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-SemNeTShiny.R
\name{plot.compareShiny}
\alias{plot.compareShiny}
\title{Plots Networks for Comparison from Shiny}
\usage{
\method{plot}{compareShiny}(x, ...)
}
\arguments{
\item{x}{Shiny result \code{resultShiny$comparePlot}}

\item{...}{Additional arguments}
}
\value{
Plots networks using \code{\link[qgraph]{qgraph}}
}
\description{
Uses \code{\link[qgraph]{qgraph}}
to plot networks. Accepts any number of networks and will organize the plots
in the number of side-by-side columns using the heuristic of taking the square root of the number of 
input and rounding down to the nearest integer (i.e., \code{floor(sqrt(length(input)))}).
Performs the same operations as \code{\link[SemNeT]{compare_nets}}

\strong{Examples}
\itemize{
\item{3 networks:}
{1 x 3}
\item{6 networks:}
{2 x 3}
\item{9 networks:}
{3 x 3}
}
}
\examples{
# Simulate Datasets
one <- sim.fluency(10)
two <- sim.fluency(10)

# Compute similarity matrix
cos1 <- similarity(one, method = "cosine")
cos2 <- similarity(two, method = "cosine")

# Compute networks using NetworkToolbox
net1 <- NetworkToolbox::TMFG(cos1)$A
net2 <- NetworkToolbox::TMFG(cos2)$A

# Compare networks
compare_nets(net1, net2, title = list("One", "Two"), config = "spring")

# Change edge colors
compare_nets(net1, net2, title = list("One", "Two"),
config = "spring", qgraph.args = list(edge.color = "blue"))

}
\references{
Epskamp, S., Cramer, A. O. J., Waldorp, L. J., Schmittmann, V. D., & Borsboom, D. (2012).
qgraph: Network visualizations of relationships in psychometric data.
\emph{Journal of Statistical Software}, \emph{48}, 1-18.
Retrieved from: http://www.jstatsoft.org/v48/i04/

Jones, P. J. (2019).
networktools: Tools for Identifying Important Nodes in Networks.
R package version 1.2.1.
\href{https://CRAN.R-project.org/package=networktools}{https://CRAN.R-project.org/package=networktools}

Jones, P. J., Mair, P., & McNally, R. (2018).
Visualizing psychological networks: A tutorial in R.
\emph{Frontiers in Psychology}, \emph{9}, 1742.
\href{https://doi.org/10.3389/fpsyg.2018.01742}{10.3389/fpsyg.2018.01742}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
