% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Palettes.R
\name{pub_color_pal}
\alias{pub_color_pal}
\title{Color Palettes for Publication (discrete)}
\usage{
pub_color_pal(palette = "pub12")
}
\arguments{
\item{palette}{the palette name, a character string.}
}
\description{
Color palettes for publication-quality graphs. See details.
}
\details{
The following palettes are available:
\itemize{
\item {"pub12"}{A 12-color colorblind safe qualitative discrete palette.}
\item{"gray5"}{5-tons of gray.}
\item {"carnival"}{A 5-color palette inspired in the Brazilian samba schools.}
\item {"tableau20"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
\item {"tableau10"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
 \item {"tableau10light"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
\item {"tableau10medium"}{Based on software \href{http://www.tableausoftware.com/}{Tableau}}
 \item {"fte"}{fivethirtyeight.com color scales}
}
}
\examples{
library(scales)
library(ggplot2)

show_col(pub_color_pal("pub12")(12))
show_col(pub_color_pal("gray5")(6), labels = FALSE)
show_col(pub_color_pal("chalk")(8))
show_col(pub_color_pal("carnival")(4))
show_col(pub_color_pal("gdocs")(18))
show_col(pub_color_pal("tableau20")(20))
show_col(pub_color_pal("tableau10")(10))
show_col(pub_color_pal("tableau10medium")(10))
show_col(pub_color_pal("tableau10light")(10))
show_col(pub_color_pal("cyclic")(20))
show_col(pub_color_pal("bivariate1")(9))

}

