% Generated by roxygen2 (4.0.2): do not edit by hand
\name{addFootnote}
\alias{addFootnote}
\title{Add Footnote to a ggplot Object}
\usage{
addFootnote(x = NULL, size = NULL, color = NULL, rotation = 90,
  justification = c("right", "bottom"))
}
\arguments{
\item{x}{any text or empty to use default.}

\item{size}{the font size \code{x}.}

\item{color}{the color for \code{x}.}

\item{rotation}{the rotation for the footnote, default is \code{rotation=90}.}

\item{justification}{the justification method.}
}
\description{
Add footnotes to \pkg{ggplot2} objects.
}
\details{
At this stage, this function only works for a ggplot object.
}
\examples{
# setup data
x <- seq(0, 50, 1)
supply <- x * -2 + 100
demand <- x * 2
df <- data.frame( x = x, supply=supply, demand=demand)

library(ggplot2)
ggplot(df, aes(x)) +
geom_line(aes(y = supply, colour = supply))+
geom_line(aes(y = demand, colour = demand))
addFootnote(size = .9, color = "red")
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Graphs}

