% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_criteria_plot.R
\name{threshold_criteria_plot}
\alias{threshold_criteria_plot}
\alias{threshold_criteria_plot.swmpr}
\title{Water Quality Threshold Plot For Parameters With Criteria}
\usage{
threshold_criteria_plot(swmpr_in, ...)

\method{threshold_criteria_plot}{swmpr}(swmpr_in, param = NULL, rng = NULL,
  thresholds = NULL, threshold_labs = c("Good", "Fair", "Poor"),
  threshold_cols = c("#ABD9E9", "#FFFFCC", "#FEC596"),
  crit_threshold = NULL, log_trans = FALSE, monthly_smooth = FALSE,
  plot_title = FALSE, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{y_labeler}}.}

\item{param}{chr string of the variable to plot}

\item{rng}{num, years to include in the plot. This variable can either be one year (e.g., \code{rng = 2012}), or two years (e.g. \code{rng = c(2012, 2016)}) , If range is not specified then the entire data set will be used.}

\item{thresholds}{numeric vector, numeric criteria that will be plotted in the background}

\item{threshold_labs}{chr vector of labels for categories created by \code{thresholds}.}

\item{threshold_cols}{chr vector of color values for categories created by \code{thresholds}.}

\item{crit_threshold}{num, value at which the critical threshold line should be plotted. Typically the same value used to establish the 'Poor' threshold.}

\item{log_trans}{logical, should y-axis be log? Defaults to \code{FALSE}}

\item{monthly_smooth}{logical, calculate a monthly average? Defaults to \code{FALSE}}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Observed data compared against user-defined water quality thresholds
}
\details{
This function visualizes exceedances of numeric criteria which are specified using \code{thresholds}. Suggested numeric criteria for several parameters (dissolved oxygen, dissolved inorganic phosphorus, dissolved inorganic nitrogen, and chlorophyll-a) can be found in the USEPA National Coastal Condition Report (2012).

If the parameter of interest does not have numeric criteria, then \code{threshold_percentile_plot} is recommended.
}
\examples{
data(apacpwq)
dat_wq <- apacpwq

dat_wq <- qaqc(dat_wq, qaqc_keep = c(0, 3, 5))

## Due to the volume of instantaneous data, these plots are a bit slow
x <-
  threshold_criteria_plot(dat_wq, param = 'do_mgl'
                 , rng = 2012
                 , thresholds = c(2, 5)
                 , threshold_labs = c('Poor', 'Fair', 'Good')
                 , monthly_smooth = TRUE
                 , threshold_cols = c('#FEC596', '#FFFFCC', '#ABD9E9'))

\dontrun{
y <-
  threshold_criteria_plot(dat_wq, param = 'do_mgl'
                 , thresholds = c(2, 5)
                 , threshold_labs = c('Poor', 'Fair', 'Good')
                 , threshold_cols = c('#FEC596', '#FFFFCC', '#ABD9E9'))

z <-
  threshold_criteria_plot(dat_wq, param = 'do_mgl'
                 , rng = 2012
                 , thresholds = c(2, 5)
                 , threshold_labs = c('Poor', 'Fair', 'Good')
                 , threshold_cols = c('#FEC596', '#FFFFCC', '#ABD9E9')
                 , monthly_smooth = TRUE)

## A few examples with only two thresholds
xx <-
  threshold_criteria_plot(dat_wq, param = 'do_mgl'
                 , rng = 2012
                 , thresholds = c(2, 2)

                  # A dummy blank ('') value must be added as a threshold label
                 , threshold_labs = c('Poor', '', 'Good')
                 , threshold_cols = c('#FEC596', '#FFFFCC', '#ABD9E9')
                 , monthly_smooth = TRUE)

xy <-
  threshold_criteria_plot(dat_wq, param = 'do_mgl'
                 , rng = 2012
                 , thresholds = c(5, 5)

                 # A dummy blank ('') value must be added as a threshold label
                 , threshold_labs = c('Poor', '', 'Good')
                 , threshold_cols = c('#FEC596', '#FEC596', '#ABD9E9')
                 , monthly_smooth = TRUE)

xz <-
  threshold_criteria_plot(dat_wq, param = 'do_mgl'
                 , rng = 2012
                 , thresholds = c(2, 5)
                 , threshold_labs = c('Poor', 'Good', 'Poor')
                 , threshold_cols = c('#FEC596', '#ABD9E9', '#FEC596')
                 , monthly_smooth = TRUE)


data(apacpnut)
dat_nut <- apacpnut

dat_nut <- qaqc(dat_nut, qaqc_keep = c(0, 3, 5))
dat_nut <- rem_reps(dat_nut)

x <-
  threshold_criteria_plot(dat_nut, param = 'chla_n'
                 , thresholds = c(2, 5)
                 , threshold_labs = c('Good', 'Fair', 'Poor'))


y <-
  threshold_criteria_plot(dat_nut, param = 'chla_n'
                 , rng = 2012
                 , thresholds = c(2, 5)
                 , threshold_labs = c('Good', 'Fair', 'Poor'))

## Nutrient plots are not capable of accidentally displaying any kind of smooth
z <-
  threshold_criteria_plot(dat_nut, param = 'chla_n'
                 , rng = 2012
                 , thresholds = c(2, 5)
                 , threshold_labs = c('Good', 'Fair', 'Poor')
                 , monthly_smooth = TRUE)
}
}
\references{
United States Environmental Protection Agency (USEPA). 2012. "National Coastal Condition Report IV."
http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.646.1973&rep=rep1&type=pdf
}
\seealso{
\code{\link[ggplot2]{ggplot}},\code{\link{y_labeler}}
}
\author{
Julie Padilla
}
\concept{
analyze

analyze
}
