% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_retrieval.R
\name{all_params_dtrng}
\alias{all_params_dtrng}
\title{Get CDMO records within a date range}
\usage{
all_params_dtrng(station_code, dtrng, param = NULL, trace = TRUE,
  Max = NULL)
}
\arguments{
\item{station_code}{chr string of station, 7 or 8 characters}

\item{dtrng}{two element chr string, each of format MM/DD/YYYY}

\item{param}{chr string for a single parameter to return, defaults to all parameters for a station type.}

\item{trace}{logical indicating if import progress is printed in console}

\item{Max}{numeric indicating maximum number of records to return}
}
\value{
Returns a swmpr object, all parameters for a station type (nutrients, water quality, or meteorological) or a single parameter if specified.  QAQC columns are not provided for single parameters.
}
\description{
Get station records from the CDMO within a date range
}
\details{
This function retrieves data from the CDMO through the web services URL.  The computer making the request must have a registered IP address.  Visit the CDMO web services page for more information: \url{http://cdmo.baruch.sc.edu/webservices.cfm}.  This function is the CDMO equivalent of \code{exportAllParamsDateRangeXMLNew}.
Download time may be excessive for large requests.
}
\examples{

\dontrun{

## get all parameters within a date range
all_params_dtrng('apaebwq', c('01/01/2013', '02/01/2013'))

## get single parameter within a date range
all_params_dtrng('apaebwq', c('01/01/2013', '02/01/2013'), 
   param = 'do_mgl')

}
}
\seealso{
\code{\link{all_params}}, \code{\link{single_param}}
}
\concept{
retrieve
}

