% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateMultiOmics.R
\name{simulateMultiOmics}
\alias{simulateMultiOmics}
\title{Simulation of omics with predefined single or multiple latent factors in multi-omics}
\usage{
simulateMultiOmics(
  vector_features,
  n_samples,
  n_factors,
  snr = 2,
  signal.samples = c(5, 1),
  signal.features = NULL,
  factor_structure = "mixed",
  num.factor = "multiple",
  seed = NULL
)
}
\arguments{
\item{vector_features}{Integer vector indicating number of features per omic (length k for k omics).}

\item{n_samples}{Total number of samples across all omics.}

\item{n_factors}{Number of latent factors.}

\item{snr}{Signal-to-noise ratio.}

\item{signal.samples}{Mean and SD for generating sample signal values (e.g., c(mean, sd)).}

\item{signal.features}{List of vectors with mean and SD for features per omic (e.g., list(c(3,0.2), c(2.5,0.15))).}

\item{factor_structure}{Character. "shared", "exclusive", "mixed", "partial", or "custom" factor distribution}

\item{num.factor}{Character. "multiple" (default) or "single"}

\item{seed}{Optional. Set random seed for reproducibility.}
}
\value{
A list containing:
\itemize{
\item \code{omic.list}: List of simulated omic datasets.
\item \code{signal_annotation}: Signal sample indices per factor.
\item \code{list_alphas}, \code{list_betas}: Latent factor loading vectors.
}
}
\description{
Simulate multiple omics (>2) datasets with non-overlapping sample and feature signal blocks.
}
\details{
This function generates synthetic omics data where each omic layer has its own feature space and noise characteristics. The sample signal blocks for each latent factor are non-overlapping and sequential with random gaps. Feature signal blocks are generated per omic with sequential non-overlapping segments.
}
\examples{
sim_object1 <- simulateMultiOmics(
  vector_features = c(3000, 2500, 2000),
  n_samples = 100,
  n_factors = 3,
  snr = 3,
  signal.samples = c(5, 1),
  signal.features = list(
    c(3, 0.3),   # omic1 signal mean/sd
    c(2.5, 0.25),# omic2 signal mean/sd
    c(2, 0.2)    # omic3 signal mean/sd
  ),
  factor_structure = "mixed",
  num.factor = "multiple",
  seed = 123
)

# View available elements
names(sim_object1)

# Visualize the simulated data
plot_simData(sim_object = sim_object1, data = "merged", type = "heatmap")

sim_object2 <- simulateMultiOmics(
  vector_features = c(3000, 2500),
  n_samples = 100,
  n_factors = 1,
  snr = 0.5,
  signal.samples = c(3, 1),
  signal.features = list(
    c(3.5, 0.3),   # omic1 signal mean/sd
    c(4, 0.2)    # omic3 signal mean/sd
  ),
  factor_structure = "shared",
  num.factor = "single",
  seed = NULL
)

# Visualize the simulated data
plot_simData(sim_object = sim_object2, data = "merged", type = "heatmap")

}
