% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example6.R
\docType{data}
\name{example6.rat}
\alias{example6.rat}
\title{Example 6 of rating data of two groups of unequal size}
\format{A data frame with 10 observations of 9 ratings.  \describe{
\item{schoolid}{a numeric vector, identifying the second group
level} \item{groupid}{a numeric vector, identifying the first group
level.} \item{respid}{a numeric vector, identifying the individual.}
\item{r01}{ratings received by respondent 1.}
\item{r02}{ratings received by respondent 2.}
\item{r03}{ratings received by respondent 3.}
\item{r04}{ratings received by respondent 4.}
\item{r05}{ratings received by respondent 5.}
\item{r06}{ratings received by respondent 6.}
\item{r07}{ratings received by respondent 7.}
\item{r08}{ratings received by respondent 8.}
\item{r09}{ratings received by respondent 9.}
\item{r10}{ratings received by respondent 10.} }}
\description{
The combined data matrices of two groups, groups 10 and 20. Please note that
the missing ratings in group 10 are padded with NA's.\cr The result of
\code{readratdatafixed("<example6.rat.txt>")}. A 7-point rating scale has
been used. Each respondent is identified by a schoolid, a group id and a
respondent id. The rows contain the assessors, the columns contain the
assessed. When rater equals assessed (diagonal), the rating is NA.
}
\note{
Rating data can be entered directly into a SSrat compliant dataframe,
using \code{\link{edit}}. Colums needed are: "schoolid", "groupid",
"respid", and for <n> raters "r01", "r02".."r<n>". Optionally, a column
named "resplabel" can be entered, containing an additional identifier of the
raters/assessed. The raters (assessors) are in rows and assessed in columns.
For example: \cr mydata=data.frame(schoolid=numeric(0), groupid=numeric(0),
respid=numeric(0),\cr r01=numeric(0), r02=numeric(0), r03=numeric(0));
mydata=edit(mydata)
}
\examples{

data(example6.rat)

}
\seealso{
\code{\link{readratdatafixed}} \code{\link{calcallgroups}}
\code{\link{calcgroup}} \code{\link{example1.rat}}
\code{\link{example1a.rat}} \code{\link{example2.rat}}
\code{\link{example3.rat}} \code{\link{example4.rat}}
\code{\link{example5.rat}} %%\code{\link{example6.rat}}
\code{\link{example7.rat}} \code{\link{klas2.rat}}
}
\keyword{datasets}
