% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ssrmst.R
\name{ssrmst}
\alias{ssrmst}
\title{Sample Size Calculation using Restricted Mean Survival Time}
\usage{
ssrmst(ac_rate, ac_period, tot_time, tau, scale0, scale1, shape = 1, margin = 0,
       allocation1 = 0.5, one_sided_alpha = 0.025, seed=NULL, ntest=2000)
}
\arguments{
\item{ac_rate}{Accrual rate: the number of patients per unit time.}

\item{ac_period}{Accrual period: the time point at last accrual.}

\item{tot_time}{Total study time: the time point at last follow-up.}

\item{tau}{Truncation time point to calculate RMSTs.}

\item{scale0,scale1}{Scale parameters for the Weibull distribution in both the control (arm0) and the treatment (arm1). Note that the value of the scale parameter in the treatment (arm1) needs to be larger than or equal to that in the control (arm0), because the difference of the RMSTs (arm1 minus arm0) is of interest.}

\item{shape}{Shape parameter for the Weibull distribution in both arms. As we assume the proportional hazards, the shape parameters for the Weibull distribution in both arms are the same. When default (\code{shape = 1}), the Weibull distribution reduces to the Exponential distribution.}

\item{margin}{Non-inferiority margin: a clinically acceptable difference in RMSTs. A value of minus \code{margin} is used to evaluate the power. When default (\code{margin = 0}), a superiority test is selected.}

\item{allocation1}{Proportion of patients allocated to the treatment (arm1). Default value is 0.5.}

\item{one_sided_alpha}{Nominal type I error level as one-sided. When default (\code{one_sided_alpha = 0.025}), 0.95 confidence intervals of the difference in RMSTs are estimated to calculate the power.}

\item{seed}{Random seed used for the sampling. Default is \code{NULL}.}

\item{ntest}{Number of simulations. When default (\code{ntest = 2000}), 2,000 sets of realizations are generated for calculating confidence intervals of RMST differences.}
}
\value{
A list with components:

\item{result}{Total study population and expected number of events.}

\item{power}{Chance that the lower bound of 2,000 confidence intervals of differences in RMSTs falls above a value of minus margin in a non-inferiority test (or above 0 in a superiority test).}

\item{accrual rate}{Accrual rate used in the analyses.}

\item{accrual period}{Accrual period used in the analyses.}

\item{total study time}{Total study time used in the analyses.}

\item{margin}{Margin used in the analyses.}

\item{tau}{Truncation time point used in the analyses.}

\item{note}{Note regarding the truncation time, tau.}
}
\description{
The package calculates the study sample size and power in designing clinical trials using the differences in restricted mean survival times (RMST).
Two types of one-sided tests, non-inferiority and superiority tests, are prepared.
Under certain conditions, 2,000 sets of realizations in default are generated for calculating confidence intervals of RMST differences.
Then the power is calculated, i.e., the chance that the lower bound of 2,000 confidence intervals of RMST differences falls above a margin.
}
\details{
For more details, please refer to the vignette: \code{browseVignettes(package = "SSRMST")}
}
\examples{
#---Example data

 #--Non-inferiority test
 ac_rate   = 15
 ac_period = 35
 tot_time  = 510
 tau       = 500
 scale0    = 8500
 scale1    = 8500
 margin    = 18

 a = ssrmst(ac_rate, ac_period, tot_time, tau, scale0, scale1, margin=margin, ntest=20)
 print(a)


 #--Superiority test
 ac_rate   = 15
 ac_period = 35
 tot_time  = 510
 tau       = 500
 scale0    = 4000
 scale1    = 8500
 b = ssrmst(ac_rate, ac_period, tot_time, tau, scale0, scale1, ntest=20)
 print(b)
}
\references{
Uno H, Wittes J, Fu H, Solomon SD, Claggett B, Tian L, Cai T, Pfeffer MA, Evans SR, Wei LJ.
 Alternatives to Hazard Ratios for Comparing the Efficacy or Safety of Therapies in non-inferiority Studies.
 Annals of Internal Medicine 2015, 163, 127-134.
}
\seealso{
survival
 survRM2
}

