# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@importFrom Rcpp sourceCpp
#'@useDynLib SSOSVM
NULL

#'Square Hinge
#'@description Fit SVM with Square Hinge loss function.
#'@param YMAT Data. First column is -1 or 1 indicating the class of each observation. The remaining columns are the coordinates of the data points.
#'@param DIM Dimension of data. Default value is 2.
#'@param EPSILON Small perturbation value needed in calculation. Default value is 0.00001.
#'@param returnAll Return all of theta values? Boolean with default value FALSE.
#'@param rho Sensitivity factor to adjust the level of change in the SVM fit when a new observation is added. Default value 1.0
#'@return A list containing:
#'\item{THETA}{SVM fit parameters.}
#'\item{NN}{Number of observation points in YMAT.}
#'\item{DIM}{Dimension of data.}
#'\item{THETA_list}{THETA at each iteration (new point observed) as YMAT is fed into the algorithm one data point at a time.}
#'\item{PSI}{Intermediate value PSI at each iteration (new point observed).}
#'@examples
#'YMAT <- generateSim(10^3,DIM=3)
#'sq1<-SquareHinge(YMAT$YMAT, DIM=3, returnAll=TRUE)
#'@export
SquareHinge <- function(YMAT, DIM = 2L, EPSILON = 0.00001, returnAll = FALSE, rho = 1.0) {
    .Call('_SSOSVM_SquareHinge', PACKAGE = 'SSOSVM', YMAT, DIM, EPSILON, returnAll, rho)
}

#'Hinge
#'@description Fit SVM with Hinge loss function.
#'@param YMAT Data. First column is -1 or 1 indicating the class of each observation. The remaining columns are the coordinates of the data points.
#'@param DIM Dimension of data. Default value is 2.
#'@param EPSILON Small perturbation value needed in calculation. Default value is 0.00001.
#'@param returnAll Return all of theta values? Boolean with default value FALSE.
#'@param rho Sensitivity factor to adjust the level of change in the SVM fit when a new observation is added. Default value 1.0
#'@return A list containing:
#'\item{THETA}{SVM fit parameters.}
#'\item{NN}{Number of observation points in YMAT.}
#'\item{DIM}{Dimension of data.}
#'\item{THETA_list}{THETA at each iteration (new point observed) as YMAT is fed into the algorithm one data point at a time.}
#'\item{OMEGA}{Intermediate value OMEGA at each iteration (new point observed).}
#'@examples
#'YMAT <- generateSim(10^4)
#'h1<-Hinge(YMAT$YMAT,returnAll=TRUE)
#'@export
Hinge <- function(YMAT, DIM = 2L, EPSILON = 0.00001, returnAll = FALSE, rho = 1.0) {
    .Call('_SSOSVM_Hinge', PACKAGE = 'SSOSVM', YMAT, DIM, EPSILON, returnAll, rho)
}

#'Logistic Loss Function
#'@description Fit SVM with Logistic loss function.
#'@param YMAT Data. First column is -1 or 1 indicating the class of each observation. The remaining columns are the coordinates of the data points.
#'@param DIM Dimension of data. Default value is 2.
#'@param EPSILON Small perturbation value needed in calculation. Default value is 0.00001.
#'@param returnAll Return all of theta values? Boolean with default value FALSE.
#'@param rho Sensitivity factor to adjust the level of change in the SVM fit when a new observation is added. Default value 1.0
#'@return A list containing:
#'\item{THETA}{SVM fit parameters.}
#'\item{NN}{Number of observation points in YMAT.}
#'\item{DIM}{Dimension of data.}
#'\item{THETA_list}{THETA at each iteration (new point observed) as YMAT is fed into the algorithm one data point at a time.}
#'\item{CHI}{Intermediate value CHI at each iteration (new point observed).}
#'@examples
#'YMAT <- generateSim(10^4)
#'l1<-Logistic(YMAT$YMAT,returnAll=TRUE)
#'@export
Logistic <- function(YMAT, DIM = 2L, EPSILON = 0.00001, returnAll = FALSE, rho = 1.0) {
    .Call('_SSOSVM_Logistic', PACKAGE = 'SSOSVM', YMAT, DIM, EPSILON, returnAll, rho)
}

