\name{writeInterface}
\alias{writeInterface}
\title{Serialize generated interface to a file}
\description{
  This function allows the user to take a programmatically
  generated interface such as  with
  \code{\link{genSOAPClientInterface}}
  and write the code to a file for inclusion in an R package
  or to be source'd into a different R session.

  Note that this is not essential. One can \code{\link[base]{save}} the
  interface generated by   \code{\link{genSOAPClientInterface}}
  in RDA format and then use \code{\link[base]{load}} that into
  a different R session, potentially on a different machine,
  and the interface will work as is.
}
\usage{
writeInterface(iface, file = stdout(), where = globalenv())
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{iface}{the interface object created via a call to \code{\link{genSOAPClientInterface}}}
  \item{file}{the name of the file to which to write the code.}
  \item{where}{the position or package name used to find the
    class definitions associated with this interface.
    This is passed to \code{\link[methods]{getClass}}.
   }
}
\details{
  Currently, this has to handle deparseing S4 objects
  directly. Also, it undoes the use of environments
  within the functions to store the "cached" information
  about the operation and the SOAP server location.
  Instead, it adds these as explicit parameters and
  to the body of the code.
}
\value{
  This function is used for its side effect of writing
  content in the specified \code{file}
}

\author{Duncan Temple Lang}

\seealso{
  \code{\link{genSOAPClientInterface}}
  \code{\link{processWSDL}}
}
\examples{
w = processWSDL(system.file("examples", "KEGG.wsdl", package = "SSOAP"))
iface = genSOAPClientInterface(w)
f = tempfile()
writeInterface(iface, f)
source(f)
\dontrun{
db = list_databases()
class(db)
class(db[[1]])
}

u = "http://gmd.mpimp-golm.mpg.de/webservices/wsGoBioSpace.asmx?WSDL"
z = processWSDL(u, port = 1)
iface = genSOAPClientInterface(z)
f = tempfile()
writeInterface(iface, f)
source(f)

a = GetAdducts()
d = GetDepositors()

session = CreateSession(DepositorIds = c(3, 6, 8), AdductIds = c(2L, 3L))
sm = SearchMass12C(SessionID = session, mass = 579.1705, tolerance = 0.001)
}
\keyword{programming}
\keyword{IO}
