% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{sslLLGC}
\alias{sslLLGC}
\title{Local	and	Global	Consistency}
\usage{
sslLLGC(xl, yl, xu, dist.type = "Euclidean", alpha = 0.01, gamma = 1,
  iter = 1000)
}
\arguments{
\item{xl}{a n * p matrix or data.frame of labeled data}

\item{yl}{a n X C matrix representing  labels of n observations in C classes.If observation i belongs to class j, then yl(i,j)=1, and other elements in the same row equal 0.}

\item{xu}{a m * p matrix or data.frame of unlabeled data.}

\item{dist.type}{character string; this parameter controls the type of distance measurement.(see \code{\link{dist}} or \code{\link{pr_DB}}).}

\item{alpha}{a numeric parameter controls convergence rate.}

\item{gamma}{a numeric parameter  in the affinity matrix}

\item{iter}{the number of iteration.}
}
\value{
a m * 1 integer vector representing the predicted labels  of  unlabeled data.
}
\description{
Local	and	Global	Consistency
}
\examples{
data(iris)
xl<-iris[c(1:20,51:70,101:120),-5]
yl<-matrix(0,ncol=3,nrow=60)
yl[1:20,1]<-1
yl[21:40,2]<-1
yl[41:60,3]<-1
xu<-iris[-c(1:20,51:70,101:120),-5]
yu<-sslLLGC(xl,yl,xu)
}
\author{
Junxiang Wang
}
\references{
Zhou, D., Bousquet, O., Lal, T., Weston, J. and Scholkopf, B. (2004). Learning with local and global consistency.
}
\seealso{
\code{\link{pr_DB}} \code{\link{dist}}
}

