% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findMotif.R
\name{findMotif}
\alias{findMotif}
\title{Returns an alignment data frame of alleles that share a specific amino acid motif}
\usage{
findMotif(motif)
}
\arguments{
\item{motif}{An amino acid motif in the following format: Locus*##$~##$~##$, where ## identifies a peptide position, and $ identifies an amino acid residue. Motifs can include any number of amino acids.}
}
\value{
An amino acid alignment dataframe of alleles that share the specified motif. If the motif is not found in any alleles, or the motif has formatting errors, a warning message is returned.
}
\description{
Consumes the alignment data frame produced by BLAASD() and returns an alignment data frame of alleles that share a specific amino acid motif.
}
\examples{

#example with actual motif
\donttest{findMotif("DRB1*26F~28E~30Y")}
\donttest{("DRB1*26F~28E")}

#example with non-existent motif
\donttest{findMotif("DRB1*26F~28E~30Z")}

#extracting names of alleles with user-defined motif
findMotif("DRB1*26F~28E~30Y")[,4]
}
