% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMotif.R
\name{checkMotif}
\alias{checkMotif}
\title{Syntactic and semantic validation of HLA amino acid motifs}
\usage{
checkMotif(motif)
}
\arguments{
\item{motif}{An amino acid motif in the following format: Locus*##$~##$~##$, where ## identifies a peptide position, and $ identifies an amino acid residue. Motifs can include any number of amino acids.}
}
\value{
A warning message if the input motif is formatted incorrectly, or contains an amino acid position not present in the alignment. Otherwise, a list object with extracted locus information, a correctly formatted motif, and locus specific amino acid dataframe are returned. Note checkMotif() does not check amino acid variants in a specified motif; that is done by findMotif().
}
\description{
Checks input motif for errors in format and amino acid positions not present in the locus alignment.
}
\note{
For internal SSHAARP use only.
}
\examples{
#Example where a motif is formatted correctly
\donttest{checkMotif("DRB1*26F~28E~30Y")}

#Example where format is incorrect
\donttest{checkMotif("DRB1**26F~28E~30Y")}

#Example where an amino acid position does not exist
\donttest{checkMotif("DRB1**26F~28E~300000Y")}
}
