% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\docType{methods}
\name{evaluate}
\alias{evaluate}
\alias{evaluate,Algorithm.SDM-method}
\alias{evaluate,MAXENT.SDM-method}
\alias{evaluate,Stacked.SDM-method}
\title{Evaluate}
\usage{
evaluate(obj, ...)

\S4method{evaluate}{Algorithm.SDM}(obj, cv, cv.param, thresh = 1001,
  metric = "SES", Env, ...)

\S4method{evaluate}{MAXENT.SDM}(obj, cv, cv.param, thresh = 1001,
  metric = "SES", Env, ...)

\S4method{evaluate}{Stacked.SDM}(obj, ...)
}
\arguments{
\item{obj}{Stacked.SDM. SSDM to evaluate}

\item{...}{unused argument}

\item{cv}{character. Method of cross-validation used to evaluate the SDM (see
details below).}

\item{cv.param}{numeric. Parameters associated to the method of
cross-validation used to evaluate the SDM (see details below).}

\item{thresh}{numeric. A single integer value representing the number of equal
interval threshold values between 0 and 1 (see
\code{\link[SDMTools]{optim.thresh}}).}

\item{metric}{character. Metric(s) used to select the best SDMs that will be
included in the ensemble SDM (see details below).}

\item{Env}{raster object. Stacked raster object of environmental variables
(can be processed first by \code{\link{load_var}}).}
}
\value{
SDM/ESDM/SSDM evaluation in a data.frame
}
\description{
Evaluation of SDM or ESDM habitat suitability predictions or evalaution of
SSDM floristic composition with Pottier et al, 2013 method (see reference
below)
}
\examples{

\dontrun{
# Loading data
data(Env)
data(Occurrences)
# SSDM building
SSDM <- stack_modelling(c('CTA', 'SVM'), Occurrences, Env, rep = 1,
                       Xcol = 'LONGITUDE', Ycol = 'LATITUDE',
                       Spcol = 'SPECIES')

# Evaluation
evaluate(SSDM)

}

}
\references{
Pottier, J., Dubuis, A., Pellissier, L., Maiorano, L., Rossier,
  L., Randin, C. F., Guisan, A. (2013). The accuracy of plant assemblage
  prediction from species distribution models varies along environmental
  gradients. Global Ecology and Biogeography, 22(1), 52-63.
  https://doi.org/10.1111/j.1466-8238.2012.00790.x
}
