% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_occ.R
\name{load_occ}
\alias{load_occ}
\title{Load occurrence data}
\usage{
load_occ(path = getwd(), Env, file = NULL, ..., Xcol = "Longitude",
  Ycol = "Latitude", Spcol = NULL, GeoRes = TRUE,
  reso = max(res(Env@layers[[1]])), verbose = TRUE, GUI = FALSE)
}
\arguments{
\item{path}{character. Path to the directory that contains the occurrence table.}

\item{Env}{raster stack. Environmental variables in the form of a raster stack used to
perform spatial thinning (can be the result of the
\code{\link{load_var}} function).}

\item{file}{character. File containing the occurrence table, if NULL
(default) the .csv file located in the path will be loaded.}

\item{...}{additional parameters given to \code{\link[utils]{read.csv}}.}

\item{Xcol}{character. Name of the column  in the occurrence table  containing
Latitude or X coordinates.}

\item{Ycol}{character. Name of the column in the occurrence table  containing
Longitude or Y coordinates.}

\item{Spcol}{character. Name of the column containing species names or IDs.}

\item{GeoRes}{logical. Geographical thinning will be perform on occurrences
to limit geographical biases in the SDMs.}

\item{reso}{numeric. Resolution used to perform the geographical thinning, by
default the resolution of the raster stack (Env).}

\item{verbose}{logical. If set to true, allows the function to print text in the
console.}

\item{GUI}{logical. Don't take that argument into account (parameter for the
user interface).}
}
\value{
A data frame containing the occurrence dataset (spatially thinned or
 not).
}
\description{
Function to load occurrence data from a table to perform \code{\link{modelling}},
\code{\link{ensemble_modelling}} or \code{\link{stack_modelling}}.
}
\examples{
load_occ(path = system.file('extdata',  package = 'SSDM'), Env,
         Xcol = 'LONGITUDE', Ycol = 'LATITUDE',
         file = 'Occurences.txt', sep = ',')

}
\seealso{
\code{\link{load_var}} to load environmental variables.
}
