\name{SPREDA-package}
\alias{SPREDA-package}
\alias{SPREDA}
\docType{package}
\title{
Statistical Package for Reliability Data Analysis
}
\description{
The Statistical Package for REliability Data Analysis (SPREDA) implements recently-developed statistical methods for the analysis of reliability data. Modern technological developments, such as sensors and smart chips, allow us to dynamically track product/system usage as well as other environmental variables, such as temperature and humidity. We refer to these variables as dynamic covariates. The package contains functions for the analysis of time-to-event data with dynamic covariates and degradation data with dynamic covariates. The package also contains functions that can be used for analyzing time-to-event data with right censoring, and with left truncation and right censoring. Financial support from NSF and DuPont are acknowledged.   
}
\details{
\tabular{ll}{
Package: \tab SPREDA\cr
Type: \tab Package\cr
Version: \tab 1.1\cr
Date: \tab 2018-11-25\cr
License: \tab GPL-2\cr
}
Contains functions that are useful for the analysis of reliability data.
}
\author{
Yili Hong, Yimeng Xie, and Zhibing Xu

Maintainer: Yili Hong <yilihong@vt.edu>
}
\references{
Hong, Y., W. Q. Meeker, and J. D. McCalley (2009). Prediction of Remaining Life of Power Transformers Based on Left Truncated and Right Censored Lifetime Data. \emph{The Annals of Applied Statistics}, Vol. 3, pp. 857-879. 
 
Hong, Y. and Meeker, W. Q. (2010), Field-Failure and Warranty Prediction Using Auxiliary Use-rate Data. \emph{Technometrics}, Vol. 52, pp. 148-159.

Hong, Y. and Meeker, W. Q. (2013), Field-Failure Predictions Based on Failure-time Data with Dynamic Covariate Information, \emph{Technometrics}, Vol. 55, pp. 135-149.

Hong, Y. (2013), On Computing the Distribution Function for the Poisson Binomial Distribution, \emph{Computational Statistics and Data Analysis}, Vol. 59, pp. 41-51.  

Hong. Y., Y. Duan, W. Q. Meeker, D. L. Stanley, and X. Gu (2014), Statistical Methods for Degradation Data with Dynamic Covariates Information and an Application to Outdoor Weathering Data, \emph{Technometrics}, DOI: 10.1080/00401706.2014.915891.

Meeker, W. Q. and L. A. Escobar (1998). Statistical Methods for Reliability Data. \emph{John Wiley & Sons}.

Meeker, W. Q. and L. A. Escobar (2014). RSplida. http://www.public.iastate.edu/~stat533/.

Xu, Z., Y. Hong, and R. Jin (2014), Nonlinear General Path Models for Degradation Data with Dynamic Covariates, submitted.

}

\keyword{ package }
