% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{cal_2panel}
\alias{cal_2panel}
\title{cal_2panel
Draws calibration curves (with legend) with a second panel underneath showing predicted differences.}
\usage{
cal_2panel(
  cals,
  labels,
  col = 1:length(cals),
  lty = rep(1, length(col)),
  xy_lty = 2,
  xy_col = phs_colours("phs-magenta"),
  ci_col = rep(NA, length(col)),
  highlight = NULL,
  mar_scale = 1,
  yrange_lower = NULL,
  ...
)
}
\arguments{
\item{cals}{list of calibration objects, output from getcal().}

\item{labels}{labels to use in legend}

\item{col}{line colours}

\item{lty}{line type, defaults to 1}

\item{xy_lty}{line type for x-y line, defaults to 2 (dashed)}

\item{xy_col}{line colour for x-y line, defaults to phs-magenta}

\item{ci_col}{colours to draw confidence intervals on lower panel; NA to not draw.}

\item{highlight}{if non-null, highlight a particular value}

\item{mar_scale}{scale bottom and left margins by this amount. Also scales legend.}

\item{yrange_lower}{y range for lower plot. If NULL, generates automatically}

\item{...}{other parameters passed to legend()}
}
\value{
No return value, draws a figure
}
\description{
cal_2panel
Draws calibration curves (with legend) with a second panel underneath showing predicted differences.
}
\examples{
# See vignette
}
