% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.smle.R
\name{plot.smle}
\alias{plot.smle}
\title{Plots to visualize the SMLE screening step}
\usage{
\method{plot}{smle}(x, num_path = NULL, which_path = NULL, out_plot = 5, ...)
}
\arguments{
\item{x}{Fitted  \code{"smle"} object from SMLE.}

\item{num_path}{Number of top coefficients to be shown in solution path plot.
Default in solution path plot is equal to the number of features retained in the model.}

\item{which_path}{A vector to control which features are shown in addition to the paths for the most significant coefficients.}

\item{out_plot}{A number from 1 to 5 indicating which plot is to be shown in the separate window; the default for solution path plot is "5".
See Description for plot labels 1-4.}

\item{...}{Additional arguments passed to the second plot.}
}
\value{
No return value.
}
\description{
This function returns two plot windows. By default, the first contains 4 plots to assess convergence:
1) log-likelihood,  2) Euclidean distance between the current
and the previous coefficient estimates,   3)  the number of tries in tuning parameter "u" in IHT
algorithm (see details of \code{SMLE()}),  and 4) the number of features changed in the current active set.
By default, the second plot shows the solution path (estimated coefficient by iteration step) for selected features.
}
\examples{
Data<-Gen_Data(correlation="MA",family = "gaussian")
fit<-SMLE(Data$Y,Data$X,k=20,family = "gaussian")
plot(fit)

}
