% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik.smle}
\alias{logLik.smle}
\alias{logLik.selection}
\title{Extract log-likelihood}
\usage{
\method{logLik}{smle}(object, ...)

\method{logLik}{selection}(object, ...)
}
\arguments{
\item{object}{Object of class \code{'smle'} or \code{'sdata'}.}

\item{...}{Forwarded arguments.}
}
\value{
Returns an object of class logLik. This is a number with at least one attribute,
 "df" (degrees of freedom), giving the number of (estimated) parameters in the model. For more details, see the generic logLik().
}
\description{
This is a method function written to extract log-liklihood from \code{'smle'} and \code{'selection'} objects. 
It refits the model by \code{glm} based on the response and the selected features after screening( selection ), 
and returns an object of \code{'logLik'} from the generic.
}
\examples{
Data<-Gen_Data(n=100, p=5000, family = "gaussian", correlation="ID")
Data
fit<-SMLE(Y=Data$Y, X=Data$X, k=9, family = "gaussian")
fit
logLik(fit)

}
