% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2geojson.R
\name{df2geojson}
\alias{df2geojson}
\title{df2geojson}
\usage{
df2geojson(df, multipleValuesByTime = c())
}
\arguments{
\item{df}{Data frame to convert in GeoJSON.
It must contain at least columns 'id', 'time', 'X' and 'Y'.
Additionnal columns will be added as features' properties.}

\item{multipleValuesByTime}{Vector of strings indicating the df columns names which can contain several values by time.}
}
\value{
a geojson string
}
\description{
Transform a data frame into a string formatted in GeoJSON
}
\examples{
library(SMITIDvisu)
data(transmissiontree)
geojson <- df2geojson(tt.events, multipleValuesByTime = c('infectedby', 'probabilities'))
}
