% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopstoSP.R
\name{stopstoSP}
\alias{stopstoSP}
\title{Projects the GTFS stops table to a SpatialPointsDataFrame}
\usage{
stopstoSP(GTFSstops., epsg, useSIRI = FALSE, SIRI = NULL)
}
\arguments{
\item{GTFSstops.}{A subset of the GTFS stops table, should be the product of \code{\link{StopsForSIRI}}.}

\item{epsg}{a coordinate system code ( can be extracted using "make_EPSG" and searching the table).}

\item{useSIRI}{logical. use a SIRI data frame as reference?}

\item{SIRI}{if useSIRI is TRUE, which SIRI data frame to use?}
}
\value{
A \code{\link[sp]{SpatialPointsDataFrame}} with stops relevant to SIRI's real-time data.
}
\description{
Projects a subset of the GTFS stops table to a \code{\link[sp]{SpatialPointsDataFrame}} with the selected projection.
}
\details{
Requires the product of \code{\link{StopsForSIRI}},
is interchangeable with \code{\link{stopstoILTM}} for Israel's TM grid.
the function is a part of STG and should not be used on it's own.
}
\section{Warning}{

Do Not use this function on it's own, it is meant to be used only as part of the STG process
}

\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Spatial and Temporal Estimation of the Service Reliability of Public Transportation Using Big Data and Open Source Tools}
}
\seealso{
\code{\link{STG}}, \code{\link{stopstoILTM}}, \code{\link{StopsForSIRI}}
}
\keyword{internal}
\keyword{misc}
