% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shark_api_functions.R
\name{get_shark_options}
\alias{get_shark_options}
\title{Retrieve available search options from SHARK}
\usage{
get_shark_options(prod = TRUE, utv = FALSE, unparsed = FALSE)
}
\arguments{
\item{prod}{Logical value that selects the production server when \code{TRUE}
and the test server when \code{FALSE}, unless \code{utv} is \code{TRUE}.}

\item{utv}{Logical value that selects the UTV server when \code{TRUE}.}

\item{unparsed}{Logical. If \code{TRUE}, returns the complete JSON response as a nested list without parsing.
Defaults to \code{FALSE}.}
}
\value{
A named \code{list} of available search options from the SHARK API.
If \code{unparsed = TRUE}, returns the raw JSON structure as a list.
}
\description{
The \code{get_shark_options()} function retrieves available search options from the SHARK database.
It sends a GET request to the SHARK API and returns the results as a structured named list.
}
\details{
This function sends a GET request to the \verb{/api/options} endpoint of the SHARK API
to retrieve available search filters and options that can be used in SHARK data queries.
}
\examples{
\donttest{
  # Retrieve available search options (simplified)
  shark_options <- get_shark_options()
  names(shark_options)

  # Retrieve full unparsed JSON response
  raw_options <- get_shark_options(unparsed = TRUE)

  # View available datatypes
  print(shark_options$dataTypes)
}

}
\seealso{
\code{\link[=get_shark_data]{get_shark_data()}} for retrieving actual data from the SHARK API.

\url{https://shark.smhi.se/en} for the SHARK database portal.
}
