% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEQestimate.R
\name{SEQestimate}
\alias{SEQestimate}
\title{Estimate the (very rough) time to run SEQuential analysis on current machine}
\usage{
SEQestimate(
  data,
  id.col,
  time.col,
  eligible.col,
  treatment.col,
  outcome.col,
  time_varying.cols = list(),
  fixed.cols = list(),
  method,
  options,
  verbose = TRUE
)
}
\arguments{
\item{data}{data.frame or data.table, if not already expanded with \code{\link[=SEQexpand]{SEQexpand()}}, will preform expansion according to arguments passed to either \code{params} or \code{...}}

\item{id.col}{String: column name of the id column}

\item{time.col}{String: column name of the time column}

\item{eligible.col}{String: column name of the eligibility column}

\item{treatment.col}{String: column name of the treatment column}

\item{outcome.col}{String: column name of the outcome column}

\item{time_varying.cols}{List: column names for time varying columns}

\item{fixed.cols}{List: column names for fixed columns}

\item{method}{String: method of analysis to preform}

\item{options}{List: optional list of parameters from \code{\link[=SEQopts]{SEQopts()}}}

\item{verbose}{Logical: if \code{TRUE}, cats progress to console, default is \code{TRUE}}
}
\value{
A list of (very rough) estimates for the time required for SEQuential containing:
\itemize{
\item \code{modelTime} estimated time used when running models
\item \code{expansionTime} estimated time used when expanding data
\item \code{totalTime} sum of model and expansion time
}
}
\description{
Estimate the (very rough) time to run SEQuential analysis on current machine
}
