library(SEERaBomb)
if(length(grep("linux",R.Version()$os))) windows <- function( ... ) X11( ... )
if(length(grep("darwin",R.Version()$os))) windows <- function( ... ) quartz( ... )
windows(width=10,height=5)
par(mfrow=c(1,2),mar=c(4.3,2,.2,1.2),oma=c(0,0,2,0),cex=1.2,cex.lab=1.2,cex.axis=1.1)
d=Sigurdson[Sigurdson$age>20,]
d$lgTlcn=log(d$tlcn)
lm1=lm(lgTlcn~age,data=d)
lm2=lm(lgTlcn~age+I(age^2),data=d)
print(summary(lm1))
print(summary(lm2))
print(anova(lm1,lm2))
lm3=lm(lgTlcn~log(age),data=d)
plot(d$tlcn~d$age,log="y",ylab="",xlab="Age",xlim=c(20,84))
title("Translocations per 100 cell equivalents",outer=T)
y=exp(lm1$coeff[1]+lm1$coeff[2]*d$age)
lines(d$age,y)
plot(d$tlcn~d$age,log="xy",ylab="",xlab="Age",xlim=c(20,84))
y=exp(lm3$coeff[1]+lm3$coeff[2]*log(d$age))
lines(d$age,y)


