% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{reduce_dimensionality}
\alias{reduce_dimensionality}
\title{Dimensionality reduction}
\usage{
reduce_dimensionality(dist, ndim, rescale=TRUE)
}
\arguments{
\item{dist}{A numeric matrix, data frame or "\code{dist}" object.}

\item{ndim}{The number of dimensions in the new space.}

\item{rescale}{A logical indicating whether or not the returned space should be rescaled and centered.}
}
\value{
A matrix containing the coordinates of each sample, represented in an \code{ndim}-dimensional space.
}
\description{
\code{reduce_dimensionality} performs an eigenanalysis of the given dissimilarity matrix and returns coordinates of the samples represented in an \code{ndim}-dimensional space.
}
\examples{
## Generate an example dataset
dataset <- generate_dataset(type = "poly", num_genes = 500, num_samples = 1000, num_groups = 4)

## Reduce the dimensionality of this dataset
dist <- correlation_distance(dataset$expression)
space <- reduce_dimensionality(dist, ndim = 2)

## Visualise the dataset
draw_trajectory_plot(space, progression_group=dataset$sample_info$group_name)
}
\seealso{
\code{\link{correlation_distance}}, \code{\link{scale_uniform}}, \code{\link{draw_trajectory_plot}}
}
