% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{scale_uniform}
\alias{scale_uniform}
\title{Scaling and centering of matrix-like objects}
\usage{
scale_uniform(x, center = 0, max_range = 1)
}
\arguments{
\item{x}{A numeric matrix or data frame.}

\item{center}{The new center point of the data.}

\item{max_range}{The maximum range of each column.}
}
\value{
The centered, scaled matrix. The numeric centering and scalings used are returned as attributes.
}
\description{
\code{scale_uniform} uniformily scales a given matrix such that
the returned space is centered on \code{center}, and each column was scaled equally
such that the range of each column is at most \code{max_range}.
}
\examples{
## Generate a matrix from a normal distribution
## with a large standard deviation, centered at c(5, 5)
x <- matrix(rnorm(200*2, sd = 10, mean = 5), ncol=2)

## Center the dataset at c(0, 0) with a minimum of c(-.5, -.5) and a maximum of c(.5, .5)
x_scaled <- scale_uniform(x, center=0, max_range=1)

## Plot rescaled data
plot(x_scaled)

## Show ranges of each column
apply(x_scaled, 2, range)
}
