% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sine_initial.R
\name{sine_initial}
\alias{sine_initial}
\title{Cosine model fitting with given initialization for two parameters.}
\usage{
sine_initial(data, amplitude, intercept)
}
\arguments{
\item{data}{A data frame that contains the data for one individual. There should be two columns
with names 'distance' and 'oxygen'.}

\item{amplitude}{Initial value for the amplitude parameter.}

\item{intercept}{Initial value for the intercept parameter.}
}
\value{
A fitted model object from the nls function in R:

\item{m}{an 'nlsModel' object incorporating the model.}
\item{convInfo}{a list with convergence information}
\item{data}{the expression that was passed to 'nls' as the data argument. The actual data values are present in the environment of the 'm' component.}
\item{call}{the matched call with several components, notably 'algorithm'}
\item{dataClasses}{the '"dataClasses"' attribute (if any) of the '"terms"' attribute of the model frame.}
\item{control}{the control 'list' used}
}
\description{
Performs the updated nonlinear least squares (NLS) regression method for the cosine
model proposed by Balasse et al. The method calculates with the proposed initial values for ampliitude and intercept,
and then fits the NLS method as required.
}
\examples{
armenia_split = split(armenia,f = armenia$ID)
amp = seq(1,10,by=0.5)
int = seq(-25,0,by=0.5)
sine_initial(armenia_split[[2]],amp[3],int[4])
}
\references{
Florent Baty, Christian Ritz, Sandrine Charles, Martin Brutsche, Jean-Pierre Flandrois, Marie-Laure Delignette-Muller (2015). A Toolbox for Nonlinear Regression in R: The Package nlstools. Journal of Statistical Software, 66(5), 1-21. URL http://www.jstatsoft.org/v66/i05/.
}
