% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSR_Estim.R
\name{SCSR_Estim}
\alias{SCSR_Estim}
\title{Estimate spatially-clustered spatial regression models}
\usage{
SCSR_Estim(
  Formula,
  Data_sf,
  listW,
  G = 2,
  Phi = 1,
  Type = c("SCLM", "SCSAR", "SCSEM", "SCSLX"),
  CenterVars = FALSE,
  ScaleVars = FALSE,
  Maxitr = 100,
  RelTol = 10^-6,
  AbsTol = 10^-5,
  Verbose = TRUE,
  Seed = 123456789
)
}
\arguments{
\item{Formula}{a symbolic description of the regression model to be fit. The details of model specification are given for \code{lm(...)}}

\item{Data_sf}{A \code{data.frame} object of class \code{sf} with n rows (each one corresponding to a location/polygon) and a user-defined number of columns.
The data frame must contain the response variable and all the covariates to be used in the model. Also, it must include the \code{geometry} feature for spatial modelling and representation.
Typically, \code{sf} \code{data.frame} are built using the \code{st_as_sf(...)} command from the \code{sf} package (see its documentation for details).}

\item{listW}{\code{listw} object. It contains the spatial weights for the spatial autoregressive component.
Typically, listW is built using the \code{nb2listw(...)} command from the \code{spdep} package (see its documentation for details).
We suggest to adopt one of matrix styles suggested in the \code{spdep} package, such as \code{W} (row-standardized) or \code{B} (binary).
We also suggest to adopt a \code{zero.policy = TRUE} option to allow the computation of groups/clusters with isolated units. In this regard, we recall that if \code{zero.policy = FALSE} and \code{Type = "SCSAR"} causes \code{SCSR_Estim(...)} to terminate with an error.
See package \code{spatialreg} for details on the \code{zero.policy} input.}

\item{G}{Integer value. Number of clusters to be considered. When 'G=1', the pooled regression (no clusterwise) is estimated. Default is 'G = 2'.}

\item{Phi}{Non-negative (>=0) real value. Spatial penalty parameter. Default is 'Phi = 1'.}

\item{Type}{Character. Declares which model specification has to be estimated. Admitted strings are:
\itemize{
 \item{\code{"SCLM"} for linear regression model without spatial effects (LM);}
 \item{\code{"SCSAR"} for spatial autoregressive (SAR) model;}
 \item{\code{"SCSEM"} for linear regression model with spatial autoregressive error term or spatial Durbin model (SEM);}
 \item{\code{"SCSLX"} for linear regression model with spatially-lagged response variable and covariates (SLX);}
}}

\item{CenterVars}{\code{Logical} value (\code{TRUE} or \code{FALSE}) stating whether the response variable and the covariates have to be centered around the mean in the iterative algorithm to update memberships and group-wise parameters.
Centering is only use in the iterative procedure, while final estimates provided to the user are computed original (i.e., non-centered) variables.}

\item{ScaleVars}{\code{Logical} value (\code{TRUE} or \code{FALSE}) stating whether the response variable and the covariates have to be scaled with respect to their standard deviation in the iterative algorithm to update memberships and group-wise parameters.
Scaling is only used in the iterative procedure, while final estimates provided to the user are computed original (i.e., non-scaled) variables.}

\item{Maxitr}{Integer value. Maximum number of iterations for the iterative algorithm. Convergence criterion is fixed to  \eqn{\varepsilon} = 10^(-5).}

\item{RelTol}{Tolerance for the relative improvement in the log-likelihood (exit criterion) from iteration k to k+1. Default is \eqn{\varepsilon_{Rel}} = 10^-6}

\item{AbsTol}{Tolerance for the absolute improvement in the log-likelihood (exit criterion) from iteration k to k+1. Default is \eqn{\varepsilon_{Abs}} = 10^-5}

\item{Verbose}{\code{Logical} value (\code{TRUE} or \code{FALSE}). Toggle warnings and messages. If \code{verbose = TRUE} (default) the function
prints on the screen some messages describing the progress of the tasks. If \code{verbose = FALSE} any message about the progression is suppressed.}

\item{Seed}{Integer value. Define the random number generator (RNG) state for random number generation in R.
Deafult is \code{seed = 123456789}.}
}
\value{
A list object containing the following outputs:
\itemize{
\item{ClusterFitModels: G-dimensional list containing the estimated clustered regression models of class \code{lm} or \code{Sarlm}}
\item{Beta: (G x p) matrix of cluster-wise or pooled regression coefficients}
\item{Sig: G-dimensional vector of cluster-wise standard deviations}
\item{VCov: (p x p x G) array of cluster-wise variance-covariance matrices of coefficients}
\item{W_g: G-dimensional list containing for the g-th cluster with cardinality n_g a (n_g x n_g) spatial weighting matrix}
\item{listW_g: G-dimensional list containing for the g-th cluster the weights list}
\item{Group: (n x 1) vector of group assignment}
\item{sBeta: (n x p) matrix of location-wise regression coefficients}
\item{sSig: (n x 1) vector of location-wise standard deviations}
\item{MLE: Estimated maximum log-likelihood}
\item{Iter: The number of iteration needed to satisfy the convergence criterion and end up the clustering iterative loop}
}
}
\description{
Estimates spatially-clustered spatial regression (SCSR) models, such as the spatially-clustered linear regression model (SCLM),
the spatially-clustered spatial autoregressive model (SCSAR), the spatially-clustered spatial durbin model (SCSEM),
and the spatially-clustered linear regression model with spatially-lagged exogenous covariates and response variable (SCSLX).
Estimation is performed via cluster-wise maximum likelihood as presented in <https://arxiv.org/abs/2407.15874>.
}
\details{
The package \code{SCSR} computes the spatially-clustered spatial regression models based on the \code{spatialreg} package (see <https://cran.r-project.org/web/packages/spatialreg/index.html>).
SCSAR model is estimated using the function \code{lagsarlm}; SCSEM model is estimated using the function \code{errorsarlm}; SCSLX model is estimated using the function \code{lmSLX}.
SCLM model is estimated using the \code{lm} function from package \code{stats}.
Thus, estimated SCSAR, SCSEM and SCSLX models belong to class \code{Sarlm}, while estimated SCLM belongs to class \code{lm}.
We kindly refer to the package \code{spatialreg} for any detail regarding computational aspects (e.g., optimization).
Also, we refer to the package \code{spdep} for computational details on the spatial weighting matrix via \code{listw2mat(...)}, \code{nb2listw(...)} and \code{nb2mat(...)} from the \code{spdep} package.
For computional details on the spatially-clustered models, we kindly refer to Cerqueti, R., Maranzano, P. & Mattera, R. "Spatially-clustered spatial autoregressive models with application to agricultural market concentration in Europe". arXiv preprints (<doi:10.48550/arXiv.2407.15874>)
}
\examples{
data(Data_RC_PM_RM_JABES2024, package="SCDA")
SCSAR <- SCSR_Estim(Formula = "Gini_SO ~ GDPPC_PPS2020 + Share_AgroEmp",
                    Data_sf = Data2020, G=3, listW=listW, Type="SCSAR", Phi = 0.50)
SCLM <- SCSR_Estim(Formula = "Gini_SO ~ GDPPC_PPS2020 + Share_AgroEmp",
                   Data_sf = Data2020, G=3, listW=listW, Type="SCLM", Phi = 0.50)


}
