# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title
#' getneighborhood_fast
#' @description
#' an efficient function to find the neighborhood based on the matrix of position and a pre-defined cutoff
#'
#' @param x is a n-by-2 matrix of position.
#' @param cutoff is a threashold of Euclidean distance to decide whether a spot is an neighborhood of another spot. For example, if the Euclidean distance between spot A and B is less than cutoff, then A is taken as the neighbourhood of B. 
#' @return A sparse matrix containing the neighbourhood
#' @examples
#' pos = cbind(rep(1:5, each=5), rep(1:5, 5))
#' Adj = getneighborhood_fast(pos, 2)
#' @export
getneighborhood_fast <- function(x, cutoff) {
    .Call(`_SC_MEB_getneighborhood_fast`, x, cutoff)
}

ICMEM <- function(y, x_int, Adj, mu_int, sigma_int, alpha, beta_grid, PX, maxIter_ICM, maxIter) {
    .Call(`_SC_MEB_ICMEM`, y, x_int, Adj, mu_int, sigma_int, alpha, beta_grid, PX, maxIter_ICM, maxIter)
}

