% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_U_ranked}
\alias{update_U_ranked}
\title{Update latent utility vector in the ranked probit case}
\usage{
update_U_ranked(U, sys, Sigmainv)
}
\arguments{
\item{U}{The current utility vector of length \code{J-1}, differenced such that
the vector is negative.}

\item{sys}{A vector of length \code{J-1}, the systematic utility part.}

\item{Sigmainv}{The inverted error term covariance matrix of dimension
\code{J-1} x \code{J-1}.}
}
\value{
An updated utility vector of length \code{J-1}.
}
\description{
This function updates the latent utility vector in the ranked probit case.
}
\details{
This update is basically the same as in the non-ranked case, despite that
the truncation point is zero.
}
\examples{
U <- c(0,0)
sys <- c(0,0)
Sigmainv <- diag(2)
update_U_ranked(U, sys, Sigmainv)
}
\keyword{internal}
\keyword{posterior}
