% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\title{Simulate choice data.}
\usage{
simulate(
  form,
  N,
  T,
  J,
  re = NULL,
  alternatives = NULL,
  distr = NULL,
  standardize = NULL,
  seed = NULL,
  test_prop = NULL,
  ...
)
}
\arguments{
\item{form}{A formula object that is used to specify the probit model.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{A} are names of alternative and choice situation specific
covariates with a generic coefficient,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}
Separate multiple covariates of one type by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model
(for all except for the last alternative).
They can be removed by adding \code{+0} in the second spot.
See the vignette \code{vignette("data_management", package = "RprobitB")}
for more details.}

\item{N}{The number (greater or equal 1) of decision makers.}

\item{T}{The number (greater or equal 1) of choice occasions or a vector of choice
occasions of length \code{N} (i.e. a decision maker specific number).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the alternative specific constants, include
\code{"ASC"} in \code{re}.}

\item{alternatives}{A character vector with the names of the choice alternatives.
If not specified, the choice set is defined by the observed choices.}

\item{distr}{A named list of number generation functions from which the covariates are
drawn. Covariates for which no distribution is specified are drawn from a
standard normal distribution.
Each element of \code{distr} must be of the form
\code{"cov" = list("name" = "<name of the number generation function>",...)},
where \code{cov} is the name of the covariate and \code{...} are required
parameters for the number generation function.
Possible number generation functions are
\itemize{
\item functions of the type \code{r*} from base R (e.g. \code{rnorm}) where
all required parameters (except for \code{n}) must be specified,
\item the function \code{sample}, where all required parameters
(except for \code{size}) must be specified.
}}

\item{standardize}{A character vector of names of covariates that get standardized.
Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.
If \code{standardize = "all"}, all covariates get standardized.}

\item{seed}{Set a seed for the simulation.}

\item{test_prop}{Either \code{NULL} or a numeric between 0 and 1. In the latter case, the data
is split into a training set (of decider proportion \code{1-test_prop}) and a
testing set (of decider proportion \code{test_prop}).}

\item{...}{Optionally specify \code{alpha}, \code{C}, \code{s}, \code{b}, \code{Omega},
\code{Sigma}, \code{Sigma_full}, \code{beta}, or \code{z} for the simulation.}
}
\value{
An object of class \code{RprobitB_data}.
If \code{test_prop} is specified, a list of two \code{RprobitB_data} objects
labelled \code{"train"} and \code{"test"}.
}
\description{
This function simulates choice data for the RprobitB package.
}
\details{
See the vignette "Data management" for more details:
\code{vignette("data_management", package = "RprobitB")}.
}
\examples{
data = simulate(form = choice ~ cost | income + 0 | time,
                N = 100, T = 10, J = 3, re = "cost",
                alternatives = c("car", "bus", "scooter"))
}
