% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{robyn_train}
\alias{robyn_train}
\title{Train Robyn Models}
\usage{
robyn_train(
  InputCollect,
  hyper_collect,
  cores,
  iterations,
  trials,
  intercept_sign,
  intercept,
  nevergrad_algo,
  dt_hyper_fixed = NULL,
  ts_validation = TRUE,
  add_penalty_factor = FALSE,
  rssd_zero_penalty = TRUE,
  refresh = FALSE,
  seed = 123,
  quiet = FALSE
)
}
\arguments{
\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{hyper_collect}{List. Containing hyperparameter bounds. Defaults to
\code{InputCollect$hyperparameters}.}

\item{cores}{Integer. Default to \code{parallel::detectCores() - 1} (all cores
except one). Set to 1 if you want to turn parallel computing off.}

\item{iterations}{Integer. Recommended 2000 for default when using
\code{nevergrad_algo = "TwoPointsDE"}.}

\item{trials}{Integer. Recommended 5 for default
\code{nevergrad_algo = "TwoPointsDE"}.}

\item{intercept_sign}{Character. Choose one of "non_negative" (default) or
"unconstrained". By default, if intercept is negative, Robyn will drop intercept
and refit the model. Consider changing intercept_sign to "unconstrained" when
there are \code{context_vars} with large positive values.}

\item{intercept}{Boolean. Should intercept(s) be fitted (default=TRUE) or
set to zero (FALSE).}

\item{nevergrad_algo}{Character. Default to "TwoPointsDE". Options are
\code{c("DE","TwoPointsDE", "OnePlusOne", "DoubleFastGADiscreteOnePlusOne",
"DiscreteOnePlusOne", "PortfolioDiscreteOnePlusOne", "NaiveTBPSA",
"cGA", "RandomSearch")}.}

\item{dt_hyper_fixed}{data.frame or named list. Only provide when loading
old model results. It consumes hyperparameters from saved csv
\code{pareto_hyperparameters.csv} or JSON file to replicate a model.}

\item{ts_validation}{Boolean. When set to \code{TRUE}, Robyn will split data
by test, train, and validation partitions to validate the time series. By
default the "train_size" range is set to \code{c(0.5, 0.8)}, but it can be
customized or set to a fixed value using the hyperparameters input. For example,
if \code{train_size = 0.7}, validation size and test size will both be 0.15
and 0.15. When \code{ts_validation = FALSE}, nrmse_train is the
objective function; when \code{ts_validation = TRUE}, nrmse_val is the objective
function.}

\item{add_penalty_factor}{Boolean. Add penalty factor hyperparameters to
glmnet's penalty.factor to be optimized by nevergrad. Use with caution, because
this feature might add too much hyperparameter space and probably requires
more iterations to converge.}

\item{rssd_zero_penalty}{Boolean. When TRUE, the objective function
DECOMP.RSSD will penalize models with more 0 media effects additionally.
In other words, given the same DECOMP.RSSD score, a model with 50\% 0-coef
variables will get penalized by DECOMP.RSSD * 1.5 (larger error), while
another model with no 0-coef variables gets un-penalized with DECOMP.RSSD * 1.}

\item{refresh}{Boolean. Set to \code{TRUE} when used in \code{robyn_refresh()}.}

\item{seed}{Integer. For reproducible results when running nevergrad.}

\item{quiet}{Boolean. Keep messages off?}
}
\value{
List. Iteration results to include in \code{robyn_run()} results.
}
\description{
\code{robyn_train()} consumes output from \code{robyn_input()}
and runs the \code{robyn_mmm()} on each trial.
}
