// Generated by rstantools.  Do not edit by hand.

/*
    RoBTT is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    RoBTT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RoBTT.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_t_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 202, column 2 to column 10)",
                                                      " (in 'string', line 203, column 2 to column 25)",
                                                      " (in 'string', line 204, column 2 to column 115)",
                                                      " (in 'string', line 205, column 2 to column 113)",
                                                      " (in 'string', line 206, column 2 to column 115)",
                                                      " (in 'string', line 209, column 2 to column 20)",
                                                      " (in 'string', line 210, column 2 to column 24)",
                                                      " (in 'string', line 211, column 2 to column 24)",
                                                      " (in 'string', line 212, column 2 to column 21)",
                                                      " (in 'string', line 213, column 2 to column 10)",
                                                      " (in 'string', line 218, column 4 to column 21)",
                                                      " (in 'string', line 217, column 7 to line 219, column 3)",
                                                      " (in 'string', line 216, column 4 to column 21)",
                                                      " (in 'string', line 215, column 16 to line 217, column 3)",
                                                      " (in 'string', line 215, column 2 to line 219, column 3)",
                                                      " (in 'string', line 225, column 4 to column 66)",
                                                      " (in 'string', line 226, column 4 to column 66)",
                                                      " (in 'string', line 227, column 4 to column 62)",
                                                      " (in 'string', line 224, column 7 to line 228, column 3)",
                                                      " (in 'string', line 221, column 4 to column 62)",
                                                      " (in 'string', line 222, column 4 to column 62)",
                                                      " (in 'string', line 223, column 4 to column 62)",
                                                      " (in 'string', line 220, column 15 to line 224, column 3)",
                                                      " (in 'string', line 220, column 2 to line 228, column 3)",
                                                      " (in 'string', line 229, column 2 to column 50)",
                                                      " (in 'string', line 230, column 2 to column 50)",
                                                      " (in 'string', line 231, column 2 to column 60)",
                                                      " (in 'string', line 236, column 4 to column 51)",
                                                      " (in 'string', line 237, column 4 to column 51)",
                                                      " (in 'string', line 235, column 7 to line 238, column 3)",
                                                      " (in 'string', line 233, column 4 to column 49)",
                                                      " (in 'string', line 234, column 4 to column 49)",
                                                      " (in 'string', line 232, column 15 to line 235, column 3)",
                                                      " (in 'string', line 232, column 2 to line 238, column 3)",
                                                      " (in 'string', line 242, column 2 to column 33)",
                                                      " (in 'string', line 243, column 2 to column 40)",
                                                      " (in 'string', line 246, column 4 to column 93)",
                                                      " (in 'string', line 245, column 15 to line 247, column 3)",
                                                      " (in 'string', line 245, column 2 to line 247, column 3)",
                                                      " (in 'string', line 249, column 4 to column 91)",
                                                      " (in 'string', line 248, column 15 to line 250, column 3)",
                                                      " (in 'string', line 248, column 2 to line 250, column 3)",
                                                      " (in 'string', line 252, column 4 to column 96)",
                                                      " (in 'string', line 251, column 16 to line 253, column 3)",
                                                      " (in 'string', line 251, column 2 to line 253, column 3)",
                                                      " (in 'string', line 259, column 4 to column 90)",
                                                      " (in 'string', line 258, column 7 to line 260, column 3)",
                                                      " (in 'string', line 256, column 4 to column 59)",
                                                      " (in 'string', line 257, column 4 to column 59)",
                                                      " (in 'string', line 255, column 16 to line 258, column 3)",
                                                      " (in 'string', line 255, column 2 to line 260, column 3)",
                                                      " (in 'string', line 169, column 2 to column 12)",
                                                      " (in 'string', line 171, column 2 to column 18)",
                                                      " (in 'string', line 172, column 2 to column 18)",
                                                      " (in 'string', line 174, column 9 to column 28)",
                                                      " (in 'string', line 174, column 2 to column 33)",
                                                      " (in 'string', line 175, column 9 to column 28)",
                                                      " (in 'string', line 175, column 2 to column 33)",
                                                      " (in 'string', line 177, column 9 to column 27)",
                                                      " (in 'string', line 177, column 2 to column 36)",
                                                      " (in 'string', line 178, column 9 to column 27)",
                                                      " (in 'string', line 178, column 2 to column 34)",
                                                      " (in 'string', line 180, column 2 to column 11)",
                                                      " (in 'string', line 181, column 2 to column 11)",
                                                      " (in 'string', line 182, column 2 to column 12)",
                                                      " (in 'string', line 184, column 9 to column 27)",
                                                      " (in 'string', line 184, column 2 to column 38)",
                                                      " (in 'string', line 185, column 9 to column 27)",
                                                      " (in 'string', line 185, column 2 to column 38)",
                                                      " (in 'string', line 186, column 9 to column 27)",
                                                      " (in 'string', line 186, column 2 to column 39)",
                                                      " (in 'string', line 187, column 8 to column 27)",
                                                      " (in 'string', line 187, column 2 to column 47)",
                                                      " (in 'string', line 188, column 8 to column 27)",
                                                      " (in 'string', line 188, column 2 to column 47)",
                                                      " (in 'string', line 189, column 8 to column 26)",
                                                      " (in 'string', line 189, column 2 to column 47)",
                                                      " (in 'string', line 191, column 8 to column 27)",
                                                      " (in 'string', line 191, column 2 to column 42)",
                                                      " (in 'string', line 192, column 8 to column 27)",
                                                      " (in 'string', line 192, column 2 to column 42)",
                                                      " (in 'string', line 193, column 8 to column 26)",
                                                      " (in 'string', line 193, column 2 to column 42)",
                                                      " (in 'string', line 194, column 9 to column 27)",
                                                      " (in 'string', line 194, column 2 to column 48)",
                                                      " (in 'string', line 195, column 9 to column 27)",
                                                      " (in 'string', line 195, column 2 to column 48)",
                                                      " (in 'string', line 196, column 9 to column 27)",
                                                      " (in 'string', line 196, column 2 to column 49)",
                                                      " (in 'string', line 197, column 2 to column 19)",
                                                      " (in 'string', line 198, column 2 to column 19)",
                                                      " (in 'string', line 199, column 2 to column 20)",
                                                      " (in 'string', line 204, column 8 to column 12)",
                                                      " (in 'string', line 205, column 8 to column 12)",
                                                      " (in 'string', line 206, column 8 to column 13)",
                                                      " (in 'string', line 6, column 4 to column 13)",
                                                      " (in 'string', line 5, column 32 to line 7, column 3)",
                                                      " (in 'string', line 9, column 4 to column 25)",
                                                      " (in 'string', line 8, column 39 to line 10, column 3)",
                                                      " (in 'string', line 14, column 4 to column 75)",
                                                      " (in 'string', line 13, column 61 to line 15, column 3)",
                                                      " (in 'string', line 19, column 4 to column 13)",
                                                      " (in 'string', line 20, column 4 to column 15)",
                                                      " (in 'string', line 21, column 4 to column 12)",
                                                      " (in 'string', line 25, column 6 to column 24)",
                                                      " (in 'string', line 26, column 6 to column 26)",
                                                      " (in 'string', line 24, column 11 to line 27, column 5)",
                                                      " (in 'string', line 23, column 6 to column 33)",
                                                      " (in 'string', line 22, column 36 to line 24, column 5)",
                                                      " (in 'string', line 22, column 4 to line 27, column 5)",
                                                      " (in 'string', line 31, column 6 to column 17)",
                                                      " (in 'string', line 29, column 6 to column 31)",
                                                      " (in 'string', line 28, column 4 to line 31, column 17)",
                                                      " (in 'string', line 32, column 4 to column 14)",
                                                      " (in 'string', line 18, column 54 to line 33, column 3)",
                                                      " (in 'string', line 35, column 4 to column 13)",
                                                      " (in 'string', line 36, column 4 to column 15)",
                                                      " (in 'string', line 37, column 4 to column 12)",
                                                      " (in 'string', line 41, column 6 to column 24)",
                                                      " (in 'string', line 42, column 6 to column 26)",
                                                      " (in 'string', line 40, column 11 to line 43, column 5)",
                                                      " (in 'string', line 39, column 6 to column 33)",
                                                      " (in 'string', line 38, column 36 to line 40, column 5)",
                                                      " (in 'string', line 38, column 4 to line 43, column 5)",
                                                      " (in 'string', line 47, column 6 to column 17)",
                                                      " (in 'string', line 45, column 6 to column 31)",
                                                      " (in 'string', line 44, column 4 to line 47, column 17)",
                                                      " (in 'string', line 48, column 4 to column 14)",
                                                      " (in 'string', line 34, column 54 to line 49, column 3)",
                                                      " (in 'string', line 61, column 4 to column 12)",
                                                      " (in 'string', line 150, column 6 to column 61)",
                                                      " (in 'string', line 159, column 8 to column 65)",
                                                      " (in 'string', line 158, column 35 to line 160, column 7)",
                                                      " (in 'string', line 158, column 12 to line 160, column 7)",
                                                      " (in 'string', line 157, column 8 to column 65)",
                                                      " (in 'string', line 156, column 35 to line 158, column 7)",
                                                      " (in 'string', line 156, column 12 to line 160, column 7)",
                                                      " (in 'string', line 152, column 8 to line 155, column 10)",
                                                      " (in 'string', line 151, column 52 to line 156, column 7)",
                                                      " (in 'string', line 151, column 6 to line 160, column 7)",
                                                      " (in 'string', line 149, column 29 to line 161, column 5)",
                                                      " (in 'string', line 149, column 10 to line 161, column 5)",
                                                      " (in 'string', line 138, column 6 to column 75)",
                                                      " (in 'string', line 147, column 8 to column 79)",
                                                      " (in 'string', line 146, column 35 to line 148, column 7)",
                                                      " (in 'string', line 146, column 12 to line 148, column 7)",
                                                      " (in 'string', line 145, column 8 to column 79)",
                                                      " (in 'string', line 144, column 35 to line 146, column 7)",
                                                      " (in 'string', line 144, column 12 to line 148, column 7)",
                                                      " (in 'string', line 140, column 8 to line 143, column 10)",
                                                      " (in 'string', line 139, column 52 to line 144, column 7)",
                                                      " (in 'string', line 139, column 6 to line 148, column 7)",
                                                      " (in 'string', line 137, column 29 to line 149, column 5)",
                                                      " (in 'string', line 137, column 10 to line 161, column 5)",
                                                      " (in 'string', line 136, column 6 to column 78)",
                                                      " (in 'string', line 135, column 29 to line 137, column 5)",
                                                      " (in 'string', line 135, column 10 to line 161, column 5)",
                                                      " (in 'string', line 124, column 6 to column 80)",
                                                      " (in 'string', line 133, column 8 to column 84)",
                                                      " (in 'string', line 132, column 35 to line 134, column 7)",
                                                      " (in 'string', line 132, column 12 to line 134, column 7)",
                                                      " (in 'string', line 131, column 8 to column 84)",
                                                      " (in 'string', line 130, column 35 to line 132, column 7)",
                                                      " (in 'string', line 130, column 12 to line 134, column 7)",
                                                      " (in 'string', line 126, column 8 to line 129, column 10)",
                                                      " (in 'string', line 125, column 52 to line 130, column 7)",
                                                      " (in 'string', line 125, column 6 to line 134, column 7)",
                                                      " (in 'string', line 123, column 29 to line 135, column 5)",
                                                      " (in 'string', line 123, column 10 to line 161, column 5)",
                                                      " (in 'string', line 112, column 6 to column 76)",
                                                      " (in 'string', line 121, column 8 to column 80)",
                                                      " (in 'string', line 120, column 35 to line 122, column 7)",
                                                      " (in 'string', line 120, column 12 to line 122, column 7)",
                                                      " (in 'string', line 119, column 8 to column 80)",
                                                      " (in 'string', line 118, column 35 to line 120, column 7)",
                                                      " (in 'string', line 118, column 12 to line 122, column 7)",
                                                      " (in 'string', line 114, column 8 to line 117, column 10)",
                                                      " (in 'string', line 113, column 52 to line 118, column 7)",
                                                      " (in 'string', line 113, column 6 to line 122, column 7)",
                                                      " (in 'string', line 111, column 29 to line 123, column 5)",
                                                      " (in 'string', line 111, column 10 to line 161, column 5)",
                                                      " (in 'string', line 100, column 6 to column 101)",
                                                      " (in 'string', line 109, column 8 to column 105)",
                                                      " (in 'string', line 108, column 35 to line 110, column 7)",
                                                      " (in 'string', line 108, column 12 to line 110, column 7)",
                                                      " (in 'string', line 107, column 8 to column 105)",
                                                      " (in 'string', line 106, column 35 to line 108, column 7)",
                                                      " (in 'string', line 106, column 12 to line 110, column 7)",
                                                      " (in 'string', line 102, column 8 to line 105, column 10)",
                                                      " (in 'string', line 101, column 52 to line 106, column 7)",
                                                      " (in 'string', line 101, column 6 to line 110, column 7)",
                                                      " (in 'string', line 99, column 29 to line 111, column 5)",
                                                      " (in 'string', line 99, column 10 to line 161, column 5)",
                                                      " (in 'string', line 88, column 6 to column 77)",
                                                      " (in 'string', line 97, column 8 to column 81)",
                                                      " (in 'string', line 96, column 35 to line 98, column 7)",
                                                      " (in 'string', line 96, column 12 to line 98, column 7)",
                                                      " (in 'string', line 95, column 8 to column 81)",
                                                      " (in 'string', line 94, column 35 to line 96, column 7)",
                                                      " (in 'string', line 94, column 12 to line 98, column 7)",
                                                      " (in 'string', line 90, column 8 to line 93, column 10)",
                                                      " (in 'string', line 89, column 52 to line 94, column 7)",
                                                      " (in 'string', line 89, column 6 to line 98, column 7)",
                                                      " (in 'string', line 87, column 29 to line 99, column 5)",
                                                      " (in 'string', line 87, column 10 to line 161, column 5)",
                                                      " (in 'string', line 76, column 6 to column 80)",
                                                      " (in 'string', line 85, column 8 to column 84)",
                                                      " (in 'string', line 84, column 35 to line 86, column 7)",
                                                      " (in 'string', line 84, column 12 to line 86, column 7)",
                                                      " (in 'string', line 83, column 8 to column 84)",
                                                      " (in 'string', line 82, column 35 to line 84, column 7)",
                                                      " (in 'string', line 82, column 12 to line 86, column 7)",
                                                      " (in 'string', line 78, column 8 to line 81, column 10)",
                                                      " (in 'string', line 77, column 52 to line 82, column 7)",
                                                      " (in 'string', line 77, column 6 to line 86, column 7)",
                                                      " (in 'string', line 75, column 29 to line 87, column 5)",
                                                      " (in 'string', line 75, column 10 to line 161, column 5)",
                                                      " (in 'string', line 64, column 6 to column 77)",
                                                      " (in 'string', line 73, column 8 to column 81)",
                                                      " (in 'string', line 72, column 35 to line 74, column 7)",
                                                      " (in 'string', line 72, column 12 to line 74, column 7)",
                                                      " (in 'string', line 71, column 8 to column 81)",
                                                      " (in 'string', line 70, column 35 to line 72, column 7)",
                                                      " (in 'string', line 70, column 12 to line 74, column 7)",
                                                      " (in 'string', line 66, column 8 to line 69, column 10)",
                                                      " (in 'string', line 65, column 52 to line 70, column 7)",
                                                      " (in 'string', line 65, column 6 to line 74, column 7)",
                                                      " (in 'string', line 63, column 23 to line 75, column 5)",
                                                      " (in 'string', line 63, column 4 to line 161, column 5)",
                                                      " (in 'string', line 163, column 4 to column 14)",
                                                      " (in 'string', line 60, column 113 to line 164, column 3)"};
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
Jeffreys_mu_lpdf(const T0__& mu, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 96;
    return 0;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct Jeffreys_mu_lpdf_functor__ {
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& mu, std::ostream* pstream__)  const 
{
return Jeffreys_mu_lpdf<propto__>(mu, pstream__);
}
};
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
Jeffreys_sigma_lpdf(const T0__& sigma2, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 98;
    return stan::math::log((1 / sigma2));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct Jeffreys_sigma_lpdf_functor__ {
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& sigma2, std::ostream* pstream__)  const 
{
return Jeffreys_sigma_lpdf<propto__>(sigma2, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<T0__, T1__, T2__,
T3__>
pool_sigma(const T0__& sigma1, const T1__& sigma2, const T2__& N1,
           const T3__& N2, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 100;
    return stan::math::sqrt(
             (((pow(sigma1, 2) * N1) + (pow(sigma2, 2) * N2)) / (N1 + N2)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct pool_sigma_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<T0__, T1__, T2__,
T3__>
operator()(const T0__& sigma1, const T1__& sigma2, const T2__& N1,
           const T3__& N2, std::ostream* pstream__)  const 
{
return pool_sigma(sigma1, sigma2, N1, N2, pstream__);
}
};
template <typename T1__>
stan::promote_args_t<stan::value_type_t<T1__>>
coefs_lb(const std::vector<int>& type_in, const T1__& bound_in_arg__,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T1__>>;
  const auto& bound_in = to_ref(bound_in_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int type;
    type = std::numeric_limits<int>::min();
    
    local_scalar_t__ bound;
    bound = DUMMY_VAR__;
    
    local_scalar_t__ lb;
    lb = DUMMY_VAR__;
    
    current_statement__ = 110;
    if (logical_eq(num_elements(type_in), 0)) {
      current_statement__ = 108;
      return stan::math::negative_infinity();
    } else {
      current_statement__ = 105;
      type = type_in[(1 - 1)];
      current_statement__ = 106;
      bound = bound_in[(1 - 1)];
    }
    current_statement__ = 113;
    if (logical_eq(type, 0)) {
      current_statement__ = 112;
      lb = stan::math::negative_infinity();
    } else {
      current_statement__ = 111;
      lb = bound;
    }
    current_statement__ = 114;
    return lb;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct coefs_lb_functor__ {
template <typename T1__>
stan::promote_args_t<stan::value_type_t<T1__>>
operator()(const std::vector<int>& type_in, const T1__& bound_in,
           std::ostream* pstream__)  const 
{
return coefs_lb(type_in, bound_in, pstream__);
}
};
template <typename T1__>
stan::promote_args_t<stan::value_type_t<T1__>>
coefs_ub(const std::vector<int>& type_in, const T1__& bound_in_arg__,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T1__>>;
  const auto& bound_in = to_ref(bound_in_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int type;
    type = std::numeric_limits<int>::min();
    
    local_scalar_t__ bound;
    bound = DUMMY_VAR__;
    
    local_scalar_t__ lb;
    lb = DUMMY_VAR__;
    
    current_statement__ = 124;
    if (logical_eq(num_elements(type_in), 0)) {
      current_statement__ = 122;
      return stan::math::positive_infinity();
    } else {
      current_statement__ = 119;
      type = type_in[(2 - 1)];
      current_statement__ = 120;
      bound = bound_in[(2 - 1)];
    }
    current_statement__ = 127;
    if (logical_eq(type, 0)) {
      current_statement__ = 126;
      lb = stan::math::positive_infinity();
    } else {
      current_statement__ = 125;
      lb = bound;
    }
    current_statement__ = 128;
    return lb;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct coefs_ub_functor__ {
template <typename T1__>
stan::promote_args_t<stan::value_type_t<T1__>>
operator()(const std::vector<int>& type_in, const T1__& bound_in,
           std::ostream* pstream__)  const 
{
return coefs_ub(type_in, bound_in, pstream__);
}
};
template <typename T0__, typename T2__, typename T4__>
stan::promote_args_t<T0__, stan::value_type_t<T2__>,
stan::value_type_t<T4__>>
set_prior(const T0__& parameter, const int& prior_type,
          const T2__& prior_parameters_arg__,
          const std::vector<int>& bounds_type, const T4__& bounds_arg__,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T2__>,
          stan::value_type_t<T4__>>;
  const auto& prior_parameters = to_ref(prior_parameters_arg__);
  const auto& bounds = to_ref(bounds_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ ll;
    ll = DUMMY_VAR__;
    
    current_statement__ = 229;
    if (logical_eq(prior_type, 1)) {
      current_statement__ = 218;
      ll = normal_lpdf<false>(parameter, prior_parameters[(1 - 1)],
             prior_parameters[(2 - 1)]);
      current_statement__ = 227;
      if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
          primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
        current_statement__ = 225;
        ll = (ll -
               log_diff_exp(
                 normal_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)]),
                 normal_lcdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)])));
      } else {
        current_statement__ = 224;
        if (logical_neq(bounds_type[(1 - 1)], 0)) {
          current_statement__ = 222;
          ll = (ll -
                 normal_lccdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)]));
        } else {
          current_statement__ = 221;
          if (logical_neq(bounds_type[(2 - 1)], 0)) {
            current_statement__ = 219;
            ll = (ll -
                   normal_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)]));
          } 
        }
      }
    } else {
      current_statement__ = 217;
      if (logical_eq(prior_type, 2)) {
        current_statement__ = 206;
        ll = lognormal_lpdf<false>(parameter, prior_parameters[(1 - 1)],
               prior_parameters[(2 - 1)]);
        current_statement__ = 215;
        if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
            primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
          current_statement__ = 213;
          ll = (ll -
                 log_diff_exp(
                   lognormal_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)]),
                   lognormal_lcdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)])));
        } else {
          current_statement__ = 212;
          if (logical_neq(bounds_type[(1 - 1)], 0)) {
            current_statement__ = 210;
            ll = (ll -
                   lognormal_lccdf(bounds[(1 - 1)],
                     prior_parameters[(1 - 1)], prior_parameters[(2 - 1)]));
          } else {
            current_statement__ = 209;
            if (logical_neq(bounds_type[(2 - 1)], 0)) {
              current_statement__ = 207;
              ll = (ll -
                     lognormal_lcdf(bounds[(2 - 1)],
                       prior_parameters[(1 - 1)], prior_parameters[(2 - 1)]));
            } 
          }
        }
      } else {
        current_statement__ = 205;
        if (logical_eq(prior_type, 3)) {
          current_statement__ = 194;
          ll = cauchy_lpdf<false>(parameter, prior_parameters[(1 - 1)],
                 prior_parameters[(2 - 1)]);
          current_statement__ = 203;
          if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
              primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
            current_statement__ = 201;
            ll = (ll -
                   log_diff_exp(
                     cauchy_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                       prior_parameters[(2 - 1)]),
                     cauchy_lcdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                       prior_parameters[(2 - 1)])));
          } else {
            current_statement__ = 200;
            if (logical_neq(bounds_type[(1 - 1)], 0)) {
              current_statement__ = 198;
              ll = (ll -
                     cauchy_lccdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                       prior_parameters[(2 - 1)]));
            } else {
              current_statement__ = 197;
              if (logical_neq(bounds_type[(2 - 1)], 0)) {
                current_statement__ = 195;
                ll = (ll -
                       cauchy_lcdf(bounds[(2 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)]));
              } 
            }
          }
        } else {
          current_statement__ = 193;
          if (logical_eq(prior_type, 4)) {
            current_statement__ = 182;
            ll = student_t_lpdf<false>(parameter, prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)], prior_parameters[(3 - 1)]);
            current_statement__ = 191;
            if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
                primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
              current_statement__ = 189;
              ll = (ll -
                     log_diff_exp(
                       student_t_lcdf(bounds[(2 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)],
                         prior_parameters[(3 - 1)]),
                       student_t_lcdf(bounds[(1 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)],
                         prior_parameters[(3 - 1)])));
            } else {
              current_statement__ = 188;
              if (logical_neq(bounds_type[(1 - 1)], 0)) {
                current_statement__ = 186;
                ll = (ll -
                       student_t_lccdf(bounds[(1 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)],
                         prior_parameters[(3 - 1)]));
              } else {
                current_statement__ = 185;
                if (logical_neq(bounds_type[(2 - 1)], 0)) {
                  current_statement__ = 183;
                  ll = (ll -
                         student_t_lcdf(bounds[(2 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)],
                           prior_parameters[(3 - 1)]));
                } 
              }
            }
          } else {
            current_statement__ = 181;
            if (logical_eq(prior_type, 5)) {
              current_statement__ = 170;
              ll = gamma_lpdf<false>(parameter, prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)]);
              current_statement__ = 179;
              if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
                  primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
                current_statement__ = 177;
                ll = (ll -
                       log_diff_exp(
                         gamma_lcdf(bounds[(2 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)]),
                         gamma_lcdf(bounds[(1 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)])));
              } else {
                current_statement__ = 176;
                if (logical_neq(bounds_type[(1 - 1)], 0)) {
                  current_statement__ = 174;
                  ll = (ll -
                         gamma_lccdf(bounds[(1 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)]));
                } else {
                  current_statement__ = 173;
                  if (logical_neq(bounds_type[(2 - 1)], 0)) {
                    current_statement__ = 171;
                    ll = (ll -
                           gamma_lcdf(bounds[(2 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)]));
                  } 
                }
              }
            } else {
              current_statement__ = 169;
              if (logical_eq(prior_type, 6)) {
                current_statement__ = 158;
                ll = inv_gamma_lpdf<false>(parameter,
                       prior_parameters[(1 - 1)], prior_parameters[(2 - 1)]);
                current_statement__ = 167;
                if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
                    primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
                  current_statement__ = 165;
                  ll = (ll -
                         log_diff_exp(
                           inv_gamma_lcdf(bounds[(2 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)]),
                           inv_gamma_lcdf(bounds[(1 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)])));
                } else {
                  current_statement__ = 164;
                  if (logical_neq(bounds_type[(1 - 1)], 0)) {
                    current_statement__ = 162;
                    ll = (ll -
                           inv_gamma_lccdf(bounds[(1 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)]));
                  } else {
                    current_statement__ = 161;
                    if (logical_neq(bounds_type[(2 - 1)], 0)) {
                      current_statement__ = 159;
                      ll = (ll -
                             inv_gamma_lcdf(bounds[(2 - 1)],
                               prior_parameters[(1 - 1)],
                               prior_parameters[(2 - 1)]));
                    } 
                  }
                }
              } else {
                current_statement__ = 157;
                if (logical_eq(prior_type, 7)) {
                  current_statement__ = 155;
                  ll = uniform_lpdf<false>(parameter,
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)]);
                } else {
                  current_statement__ = 154;
                  if (logical_eq(prior_type, 8)) {
                    current_statement__ = 143;
                    ll = beta_lpdf<false>(parameter,
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)]);
                    current_statement__ = 152;
                    if ((primitive_value(
                        logical_neq(bounds_type[(1 - 1)], 0)) &&
                        primitive_value(
                        logical_neq(bounds_type[(2 - 1)], 0)))) {
                      current_statement__ = 150;
                      ll = (ll -
                             log_diff_exp(
                               beta_lcdf(bounds[(2 - 1)],
                                 prior_parameters[(1 - 1)],
                                 prior_parameters[(2 - 1)]),
                               beta_lcdf(bounds[(1 - 1)],
                                 prior_parameters[(1 - 1)],
                                 prior_parameters[(2 - 1)])));
                    } else {
                      current_statement__ = 149;
                      if (logical_neq(bounds_type[(1 - 1)], 0)) {
                        current_statement__ = 147;
                        ll = (ll -
                               beta_lccdf(bounds[(1 - 1)],
                                 prior_parameters[(1 - 1)],
                                 prior_parameters[(2 - 1)]));
                      } else {
                        current_statement__ = 146;
                        if (logical_neq(bounds_type[(2 - 1)], 0)) {
                          current_statement__ = 144;
                          ll = (ll -
                                 beta_lcdf(bounds[(2 - 1)],
                                   prior_parameters[(1 - 1)],
                                   prior_parameters[(2 - 1)]));
                        } 
                      }
                    }
                  } else {
                    current_statement__ = 142;
                    if (logical_eq(prior_type, 9)) {
                      current_statement__ = 131;
                      ll = exponential_lpdf<false>(parameter,
                             prior_parameters[(1 - 1)]);
                      current_statement__ = 140;
                      if ((primitive_value(
                          logical_neq(bounds_type[(1 - 1)], 0)) &&
                          primitive_value(
                          logical_neq(bounds_type[(2 - 1)], 0)))) {
                        current_statement__ = 138;
                        ll = (ll -
                               log_diff_exp(
                                 exponential_lcdf(bounds[(2 - 1)],
                                   prior_parameters[(1 - 1)]),
                                 exponential_lcdf(bounds[(1 - 1)],
                                   prior_parameters[(1 - 1)])));
                      } else {
                        current_statement__ = 137;
                        if (logical_neq(bounds_type[(1 - 1)], 0)) {
                          current_statement__ = 135;
                          ll = (ll -
                                 exponential_lccdf(bounds[(1 - 1)],
                                   prior_parameters[(1 - 1)]));
                        } else {
                          current_statement__ = 134;
                          if (logical_neq(bounds_type[(2 - 1)], 0)) {
                            current_statement__ = 132;
                            ll = (ll -
                                   exponential_lcdf(bounds[(2 - 1)],
                                     prior_parameters[(1 - 1)]));
                          } 
                        }
                      }
                    } 
                  }
                }
              }
            }
          }
        }
      }
    }
    current_statement__ = 230;
    return ll;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct set_prior_functor__ {
template <typename T0__, typename T2__, typename T4__>
stan::promote_args_t<T0__, stan::value_type_t<T2__>,
stan::value_type_t<T4__>>
operator()(const T0__& parameter, const int& prior_type,
           const T2__& prior_parameters, const std::vector<int>& bounds_type,
           const T4__& bounds, std::ostream* pstream__)  const 
{
return set_prior(parameter, prior_type, prior_parameters, bounds_type,
         bounds, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_t final : public model_base_crtp<model_t> {
private:
  int is_ss;
  int N1;
  int N2;
  Eigen::Matrix<double, -1, 1> x1;
  Eigen::Matrix<double, -1, 1> x2;
  Eigen::Matrix<double, -1, 1> mean_i;
  Eigen::Matrix<double, -1, 1> sd_i;
  int is_d;
  int is_r;
  int is_nu;
  Eigen::Matrix<double, -1, 1> bounds_d;
  Eigen::Matrix<double, -1, 1> bounds_r;
  Eigen::Matrix<double, -1, 1> bounds_nu;
  std::vector<int> bounds_type_d;
  std::vector<int> bounds_type_r;
  std::vector<int> bounds_type_nu;
  std::vector<double> fixed_d;
  std::vector<double> fixed_r;
  std::vector<double> fixed_nu;
  Eigen::Matrix<double, -1, 1> prior_parameters_d;
  Eigen::Matrix<double, -1, 1> prior_parameters_r;
  Eigen::Matrix<double, -1, 1> prior_parameters_nu;
  int prior_type_d;
  int prior_type_r;
  int prior_type_nu;
 
public:
  ~model_t() { }
  
  inline std::string model_name() const final { return "model_t"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_t(stan::io::var_context& context__, unsigned int random_seed__ = 0,
          std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_t_namespace::model_t";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 52;
      context__.validate_dims("data initialization","is_ss","int",
          context__.to_vec());
      is_ss = std::numeric_limits<int>::min();
      
      current_statement__ = 52;
      is_ss = context__.vals_i("is_ss")[(1 - 1)];
      current_statement__ = 53;
      context__.validate_dims("data initialization","N1","int",
          context__.to_vec());
      N1 = std::numeric_limits<int>::min();
      
      current_statement__ = 53;
      N1 = context__.vals_i("N1")[(1 - 1)];
      current_statement__ = 53;
      current_statement__ = 53;
      check_greater_or_equal(function__, "N1", N1, 0);
      current_statement__ = 54;
      context__.validate_dims("data initialization","N2","int",
          context__.to_vec());
      N2 = std::numeric_limits<int>::min();
      
      current_statement__ = 54;
      N2 = context__.vals_i("N2")[(1 - 1)];
      current_statement__ = 54;
      current_statement__ = 54;
      check_greater_or_equal(function__, "N2", N2, 0);
      current_statement__ = 55;
      validate_non_negative_index("x1", "is_ss == 0 ? N1 : 0",
                                  (logical_eq(is_ss, 0) ? N1 : 0));
      current_statement__ = 56;
      context__.validate_dims("data initialization","x1","double",
          context__.to_vec((logical_eq(is_ss, 0) ? N1 : 0)));
      x1 = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 0) ? N1 : 0));
      stan::math::fill(x1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> x1_flat__;
        current_statement__ = 56;
        assign(x1_flat__, nil_index_list(), context__.vals_r("x1"),
          "assigning variable x1_flat__");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 0) ? N1 : 0);
             ++sym1__) {
          current_statement__ = 56;
          assign(x1, cons_list(index_uni(sym1__), nil_index_list()),
            x1_flat__[(pos__ - 1)], "assigning variable x1");
          current_statement__ = 56;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 57;
      validate_non_negative_index("x2", "is_ss == 0 ? N2 : 0",
                                  (logical_eq(is_ss, 0) ? N2 : 0));
      current_statement__ = 58;
      context__.validate_dims("data initialization","x2","double",
          context__.to_vec((logical_eq(is_ss, 0) ? N2 : 0)));
      x2 = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 0) ? N2 : 0));
      stan::math::fill(x2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> x2_flat__;
        current_statement__ = 58;
        assign(x2_flat__, nil_index_list(), context__.vals_r("x2"),
          "assigning variable x2_flat__");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 0) ? N2 : 0);
             ++sym1__) {
          current_statement__ = 58;
          assign(x2, cons_list(index_uni(sym1__), nil_index_list()),
            x2_flat__[(pos__ - 1)], "assigning variable x2");
          current_statement__ = 58;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 59;
      validate_non_negative_index("mean_i", "is_ss == 1 ? 2 : 0",
                                  (logical_eq(is_ss, 1) ? 2 : 0));
      current_statement__ = 60;
      context__.validate_dims("data initialization","mean_i","double",
          context__.to_vec((logical_eq(is_ss, 1) ? 2 : 0)));
      mean_i = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 1) ? 2 : 0));
      stan::math::fill(mean_i, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mean_i_flat__;
        current_statement__ = 60;
        assign(mean_i_flat__, nil_index_list(), context__.vals_r("mean_i"),
          "assigning variable mean_i_flat__");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 60;
          assign(mean_i, cons_list(index_uni(sym1__), nil_index_list()),
            mean_i_flat__[(pos__ - 1)], "assigning variable mean_i");
          current_statement__ = 60;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 61;
      validate_non_negative_index("sd_i", "is_ss == 1 ? 2 : 0",
                                  (logical_eq(is_ss, 1) ? 2 : 0));
      current_statement__ = 62;
      context__.validate_dims("data initialization","sd_i","double",
          context__.to_vec((logical_eq(is_ss, 1) ? 2 : 0)));
      sd_i = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 1) ? 2 : 0));
      stan::math::fill(sd_i, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sd_i_flat__;
        current_statement__ = 62;
        assign(sd_i_flat__, nil_index_list(), context__.vals_r("sd_i"),
          "assigning variable sd_i_flat__");
        current_statement__ = 62;
        pos__ = 1;
        current_statement__ = 62;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 62;
          assign(sd_i, cons_list(index_uni(sym1__), nil_index_list()),
            sd_i_flat__[(pos__ - 1)], "assigning variable sd_i");
          current_statement__ = 62;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 63;
      context__.validate_dims("data initialization","is_d","int",
          context__.to_vec());
      is_d = std::numeric_limits<int>::min();
      
      current_statement__ = 63;
      is_d = context__.vals_i("is_d")[(1 - 1)];
      current_statement__ = 64;
      context__.validate_dims("data initialization","is_r","int",
          context__.to_vec());
      is_r = std::numeric_limits<int>::min();
      
      current_statement__ = 64;
      is_r = context__.vals_i("is_r")[(1 - 1)];
      current_statement__ = 65;
      context__.validate_dims("data initialization","is_nu","int",
          context__.to_vec());
      is_nu = std::numeric_limits<int>::min();
      
      current_statement__ = 65;
      is_nu = context__.vals_i("is_nu")[(1 - 1)];
      current_statement__ = 66;
      validate_non_negative_index("bounds_d", "is_d == 1 ? 2 : 0",
                                  (logical_eq(is_d, 1) ? 2 : 0));
      current_statement__ = 67;
      context__.validate_dims("data initialization","bounds_d","double",
          context__.to_vec((logical_eq(is_d, 1) ? 2 : 0)));
      bounds_d = Eigen::Matrix<double, -1, 1>((logical_eq(is_d, 1) ? 2 : 0));
      stan::math::fill(bounds_d, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bounds_d_flat__;
        current_statement__ = 67;
        assign(bounds_d_flat__, nil_index_list(),
          context__.vals_r("bounds_d"), "assigning variable bounds_d_flat__");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_d, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 67;
          assign(bounds_d, cons_list(index_uni(sym1__), nil_index_list()),
            bounds_d_flat__[(pos__ - 1)], "assigning variable bounds_d");
          current_statement__ = 67;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 68;
      validate_non_negative_index("bounds_r", "is_r == 1 ? 2 : 0",
                                  (logical_eq(is_r, 1) ? 2 : 0));
      current_statement__ = 69;
      context__.validate_dims("data initialization","bounds_r","double",
          context__.to_vec((logical_eq(is_r, 1) ? 2 : 0)));
      bounds_r = Eigen::Matrix<double, -1, 1>((logical_eq(is_r, 1) ? 2 : 0));
      stan::math::fill(bounds_r, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bounds_r_flat__;
        current_statement__ = 69;
        assign(bounds_r_flat__, nil_index_list(),
          context__.vals_r("bounds_r"), "assigning variable bounds_r_flat__");
        current_statement__ = 69;
        pos__ = 1;
        current_statement__ = 69;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_r, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 69;
          assign(bounds_r, cons_list(index_uni(sym1__), nil_index_list()),
            bounds_r_flat__[(pos__ - 1)], "assigning variable bounds_r");
          current_statement__ = 69;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 70;
      validate_non_negative_index("bounds_nu", "is_nu == 1 ? 2 : 0",
                                  (logical_eq(is_nu, 1) ? 2 : 0));
      current_statement__ = 71;
      context__.validate_dims("data initialization","bounds_nu","double",
          context__.to_vec((logical_eq(is_nu, 1) ? 2 : 0)));
      bounds_nu = Eigen::Matrix<double, -1, 1>((logical_eq(is_nu, 1) ? 2 : 0));
      stan::math::fill(bounds_nu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bounds_nu_flat__;
        current_statement__ = 71;
        assign(bounds_nu_flat__, nil_index_list(),
          context__.vals_r("bounds_nu"),
          "assigning variable bounds_nu_flat__");
        current_statement__ = 71;
        pos__ = 1;
        current_statement__ = 71;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_nu, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 71;
          assign(bounds_nu, cons_list(index_uni(sym1__), nil_index_list()),
            bounds_nu_flat__[(pos__ - 1)], "assigning variable bounds_nu");
          current_statement__ = 71;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 72;
      validate_non_negative_index("bounds_type_d", "is_d == 1 ? 2 : 0",
                                  (logical_eq(is_d, 1) ? 2 : 0));
      current_statement__ = 73;
      context__.validate_dims("data initialization","bounds_type_d","int",
          context__.to_vec((logical_eq(is_d, 1) ? 2 : 0)));
      bounds_type_d = std::vector<int>((logical_eq(is_d, 1) ? 2 : 0), std::numeric_limits<int>::min());
      
      current_statement__ = 73;
      assign(bounds_type_d, nil_index_list(),
        context__.vals_i("bounds_type_d"), "assigning variable bounds_type_d");
      current_statement__ = 74;
      validate_non_negative_index("bounds_type_r", "is_r == 1 ? 2 : 0",
                                  (logical_eq(is_r, 1) ? 2 : 0));
      current_statement__ = 75;
      context__.validate_dims("data initialization","bounds_type_r","int",
          context__.to_vec((logical_eq(is_r, 1) ? 2 : 0)));
      bounds_type_r = std::vector<int>((logical_eq(is_r, 1) ? 2 : 0), std::numeric_limits<int>::min());
      
      current_statement__ = 75;
      assign(bounds_type_r, nil_index_list(),
        context__.vals_i("bounds_type_r"), "assigning variable bounds_type_r");
      current_statement__ = 76;
      validate_non_negative_index("bounds_type_nu", "is_nu == 1 ? 2 : 0",
                                  (logical_eq(is_nu, 1) ? 2 : 0));
      current_statement__ = 77;
      context__.validate_dims("data initialization","bounds_type_nu","int",
          context__.to_vec((logical_eq(is_nu, 1) ? 2 : 0)));
      bounds_type_nu = std::vector<int>((logical_eq(is_nu, 1) ? 2 : 0), std::numeric_limits<int>::min());
      
      current_statement__ = 77;
      assign(bounds_type_nu, nil_index_list(),
        context__.vals_i("bounds_type_nu"),
        "assigning variable bounds_type_nu");
      current_statement__ = 78;
      validate_non_negative_index("fixed_d", "is_d == 0 ? 1 : 0",
                                  (logical_eq(is_d, 0) ? 1 : 0));
      current_statement__ = 79;
      context__.validate_dims("data initialization","fixed_d","double",
          context__.to_vec((logical_eq(is_d, 0) ? 1 : 0)));
      fixed_d = std::vector<double>((logical_eq(is_d, 0) ? 1 : 0), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 79;
      assign(fixed_d, nil_index_list(), context__.vals_r("fixed_d"),
        "assigning variable fixed_d");
      current_statement__ = 80;
      validate_non_negative_index("fixed_r", "is_r == 0 ? 1 : 0",
                                  (logical_eq(is_r, 0) ? 1 : 0));
      current_statement__ = 81;
      context__.validate_dims("data initialization","fixed_r","double",
          context__.to_vec((logical_eq(is_r, 0) ? 1 : 0)));
      fixed_r = std::vector<double>((logical_eq(is_r, 0) ? 1 : 0), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 81;
      assign(fixed_r, nil_index_list(), context__.vals_r("fixed_r"),
        "assigning variable fixed_r");
      current_statement__ = 82;
      validate_non_negative_index("fixed_nu", "is_nu == 0 ? 1 : 0",
                                  (logical_eq(is_nu, 0) ? 1 : 0));
      current_statement__ = 83;
      context__.validate_dims("data initialization","fixed_nu","double",
          context__.to_vec((logical_eq(is_nu, 0) ? 1 : 0)));
      fixed_nu = std::vector<double>((logical_eq(is_nu, 0) ? 1 : 0), std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 83;
      assign(fixed_nu, nil_index_list(), context__.vals_r("fixed_nu"),
        "assigning variable fixed_nu");
      current_statement__ = 84;
      validate_non_negative_index("prior_parameters_d", "is_d == 1 ? 3 : 0",
                                  (logical_eq(is_d, 1) ? 3 : 0));
      current_statement__ = 85;
      context__.validate_dims("data initialization","prior_parameters_d",
          "double",context__.to_vec((logical_eq(is_d, 1) ? 3 : 0)));
      prior_parameters_d = Eigen::Matrix<double, -1, 1>((logical_eq(is_d, 1)
                                                           ? 3 : 0));
      stan::math::fill(prior_parameters_d, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_parameters_d_flat__;
        current_statement__ = 85;
        assign(prior_parameters_d_flat__, nil_index_list(),
          context__.vals_r("prior_parameters_d"),
          "assigning variable prior_parameters_d_flat__");
        current_statement__ = 85;
        pos__ = 1;
        current_statement__ = 85;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_d, 1) ? 3 : 0);
             ++sym1__) {
          current_statement__ = 85;
          assign(prior_parameters_d,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_parameters_d_flat__[(pos__ - 1)],
            "assigning variable prior_parameters_d");
          current_statement__ = 85;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 86;
      validate_non_negative_index("prior_parameters_r", "is_r == 1 ? 3 : 0",
                                  (logical_eq(is_r, 1) ? 3 : 0));
      current_statement__ = 87;
      context__.validate_dims("data initialization","prior_parameters_r",
          "double",context__.to_vec((logical_eq(is_r, 1) ? 3 : 0)));
      prior_parameters_r = Eigen::Matrix<double, -1, 1>((logical_eq(is_r, 1)
                                                           ? 3 : 0));
      stan::math::fill(prior_parameters_r, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_parameters_r_flat__;
        current_statement__ = 87;
        assign(prior_parameters_r_flat__, nil_index_list(),
          context__.vals_r("prior_parameters_r"),
          "assigning variable prior_parameters_r_flat__");
        current_statement__ = 87;
        pos__ = 1;
        current_statement__ = 87;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_r, 1) ? 3 : 0);
             ++sym1__) {
          current_statement__ = 87;
          assign(prior_parameters_r,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_parameters_r_flat__[(pos__ - 1)],
            "assigning variable prior_parameters_r");
          current_statement__ = 87;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 88;
      validate_non_negative_index("prior_parameters_nu",
                                  "is_nu == 1 ? 3 : 0",
                                  (logical_eq(is_nu, 1) ? 3 : 0));
      current_statement__ = 89;
      context__.validate_dims("data initialization","prior_parameters_nu",
          "double",context__.to_vec((logical_eq(is_nu, 1) ? 3 : 0)));
      prior_parameters_nu = Eigen::Matrix<double, -1, 1>((
                                                            logical_eq(is_nu,
                                                              1) ? 3 : 0));
      stan::math::fill(prior_parameters_nu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_parameters_nu_flat__;
        current_statement__ = 89;
        assign(prior_parameters_nu_flat__, nil_index_list(),
          context__.vals_r("prior_parameters_nu"),
          "assigning variable prior_parameters_nu_flat__");
        current_statement__ = 89;
        pos__ = 1;
        current_statement__ = 89;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_nu, 1) ? 3 : 0);
             ++sym1__) {
          current_statement__ = 89;
          assign(prior_parameters_nu,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_parameters_nu_flat__[(pos__ - 1)],
            "assigning variable prior_parameters_nu");
          current_statement__ = 89;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 90;
      context__.validate_dims("data initialization","prior_type_d","int",
          context__.to_vec());
      prior_type_d = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      prior_type_d = context__.vals_i("prior_type_d")[(1 - 1)];
      current_statement__ = 91;
      context__.validate_dims("data initialization","prior_type_r","int",
          context__.to_vec());
      prior_type_r = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      prior_type_r = context__.vals_i("prior_type_r")[(1 - 1)];
      current_statement__ = 92;
      context__.validate_dims("data initialization","prior_type_nu","int",
          context__.to_vec());
      prior_type_nu = std::numeric_limits<int>::min();
      
      current_statement__ = 92;
      prior_type_nu = context__.vals_i("prior_type_nu")[(1 - 1)];
      current_statement__ = 93;
      validate_non_negative_index("delta", "is_d", is_d);
      current_statement__ = 94;
      validate_non_negative_index("rho", "is_r", is_r);
      current_statement__ = 95;
      validate_non_negative_index("nu_p", "is_nu", is_nu);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += is_d;
      num_params_r__ += is_r;
      num_params_r__ += is_nu;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_t_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ mu;
      mu = DUMMY_VAR__;
      
      current_statement__ = 1;
      mu = in__.scalar();
      local_scalar_t__ sigma2;
      sigma2 = DUMMY_VAR__;
      
      current_statement__ = 2;
      sigma2 = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        sigma2 = stan::math::lb_constrain(sigma2, 0, lp__);
      } else {
        current_statement__ = 2;
        sigma2 = stan::math::lb_constrain(sigma2, 0);
      }
      std::vector<local_scalar_t__> delta;
      delta = std::vector<local_scalar_t__>(is_d, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delta");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(delta[(sym1__ - 1)],
              coefs_lb(bounds_type_d, bounds_d, pstream__),
              coefs_ub(bounds_type_d, bounds_d, pstream__), lp__),
            "assigning variable delta");
        } else {
          current_statement__ = 3;
          assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(delta[(sym1__ - 1)],
              coefs_lb(bounds_type_d, bounds_d, pstream__),
              coefs_ub(bounds_type_d, bounds_d, pstream__)),
            "assigning variable delta");
        }}
      std::vector<local_scalar_t__> rho;
      rho = std::vector<local_scalar_t__>(is_r, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable rho");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rho[(sym1__ - 1)],
              coefs_lb(bounds_type_r, bounds_r, pstream__),
              coefs_ub(bounds_type_r, bounds_r, pstream__), lp__),
            "assigning variable rho");
        } else {
          current_statement__ = 4;
          assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rho[(sym1__ - 1)],
              coefs_lb(bounds_type_r, bounds_r, pstream__),
              coefs_ub(bounds_type_r, bounds_r, pstream__)),
            "assigning variable rho");
        }}
      std::vector<local_scalar_t__> nu_p;
      nu_p = std::vector<local_scalar_t__>(is_nu, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
        current_statement__ = 5;
        assign(nu_p, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable nu_p");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(nu_p, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(nu_p[(sym1__ - 1)],
              coefs_lb(bounds_type_nu, bounds_nu, pstream__),
              coefs_ub(bounds_type_nu, bounds_nu, pstream__), lp__),
            "assigning variable nu_p");
        } else {
          current_statement__ = 5;
          assign(nu_p, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(nu_p[(sym1__ - 1)],
              coefs_lb(bounds_type_nu, bounds_nu, pstream__),
              coefs_ub(bounds_type_nu, bounds_nu, pstream__)),
            "assigning variable nu_p");
        }}
      local_scalar_t__ pooled_sigma;
      pooled_sigma = DUMMY_VAR__;
      
      std::vector<local_scalar_t__> sigma_i;
      sigma_i = std::vector<local_scalar_t__>(2, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> scale_i;
      scale_i = std::vector<local_scalar_t__>(2, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> mu_i;
      mu_i = std::vector<local_scalar_t__>(2, DUMMY_VAR__);
      
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 15;
      if (logical_eq(is_nu, 1)) {
        current_statement__ = 13;
        nu = (nu_p[(1 - 1)] + 2);
      } else {
        current_statement__ = 11;
        nu = fixed_nu[(1 - 1)];
      }
      current_statement__ = 24;
      if (logical_eq(is_r, 1)) {
        current_statement__ = 20;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * rho[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 21;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - rho[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 22;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      } else {
        current_statement__ = 16;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * fixed_r[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 17;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt(
            (1 / (((2 * 1) / sigma2) * (1 - fixed_r[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 18;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      }
      current_statement__ = 25;
      assign(scale_i, cons_list(index_uni(1), nil_index_list()),
        (sigma_i[(1 - 1)] / stan::math::sqrt((nu / (nu - 2.0)))),
        "assigning variable scale_i");
      current_statement__ = 26;
      assign(scale_i, cons_list(index_uni(2), nil_index_list()),
        (sigma_i[(2 - 1)] / stan::math::sqrt((nu / (nu - 2.0)))),
        "assigning variable scale_i");
      current_statement__ = 27;
      pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                       N2, pstream__);
      current_statement__ = 34;
      if (logical_eq(is_d, 1)) {
        current_statement__ = 31;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 32;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      } else {
        current_statement__ = 28;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 29;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      }
      {
        current_statement__ = 35;
        lp_accum__.add(Jeffreys_mu_lpdf<false>(mu, pstream__));
        current_statement__ = 36;
        lp_accum__.add(Jeffreys_sigma_lpdf<false>(sigma2, pstream__));
        current_statement__ = 39;
        if (logical_eq(is_d, 1)) {
          current_statement__ = 37;
          lp_accum__.add(
            set_prior(delta[(1 - 1)], prior_type_d, prior_parameters_d,
              bounds_type_d, bounds_d, pstream__));
        } 
        current_statement__ = 42;
        if (logical_eq(is_r, 1)) {
          current_statement__ = 40;
          lp_accum__.add(
            set_prior(rho[(1 - 1)], prior_type_r, prior_parameters_r,
              bounds_type_r, bounds_r, pstream__));
        } 
        current_statement__ = 45;
        if (logical_eq(is_nu, 1)) {
          current_statement__ = 43;
          lp_accum__.add(
            set_prior(nu_p[(1 - 1)], prior_type_nu, prior_parameters_nu,
              bounds_type_nu, bounds_nu, pstream__));
        } 
        current_statement__ = 51;
        if (logical_eq(is_ss, 0)) {
          current_statement__ = 48;
          lp_accum__.add(
            student_t_lpdf<false>(x1, nu, mu_i[(1 - 1)], scale_i[(1 - 1)]));
          current_statement__ = 49;
          lp_accum__.add(
            student_t_lpdf<false>(x2, nu, mu_i[(2 - 1)], scale_i[(2 - 1)]));
        } else {
          current_statement__ = 46;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "Fitting models with t likelihood and summary statistics is not possible :(.";
          throw std::domain_error(errmsg_stream__.str());
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_t_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double mu;
      mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      mu = in__.scalar();
      double sigma2;
      sigma2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma2 = in__.scalar();
      current_statement__ = 2;
      sigma2 = stan::math::lb_constrain(sigma2, 0);
      std::vector<double> delta;
      delta = std::vector<double>(is_d, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delta");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(delta[(sym1__ - 1)],
            coefs_lb(bounds_type_d, bounds_d, pstream__),
            coefs_ub(bounds_type_d, bounds_d, pstream__)),
          "assigning variable delta");}
      std::vector<double> rho;
      rho = std::vector<double>(is_r, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable rho");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(rho[(sym1__ - 1)],
            coefs_lb(bounds_type_r, bounds_r, pstream__),
            coefs_ub(bounds_type_r, bounds_r, pstream__)),
          "assigning variable rho");}
      std::vector<double> nu_p;
      nu_p = std::vector<double>(is_nu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
        current_statement__ = 5;
        assign(nu_p, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable nu_p");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
        current_statement__ = 5;
        assign(nu_p, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(nu_p[(sym1__ - 1)],
            coefs_lb(bounds_type_nu, bounds_nu, pstream__),
            coefs_ub(bounds_type_nu, bounds_nu, pstream__)),
          "assigning variable nu_p");}
      double pooled_sigma;
      pooled_sigma = std::numeric_limits<double>::quiet_NaN();
      
      std::vector<double> sigma_i;
      sigma_i = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> scale_i;
      scale_i = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> mu_i;
      mu_i = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      vars__.emplace_back(mu);
      vars__.emplace_back(sigma2);
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        vars__.emplace_back(rho[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
        vars__.emplace_back(nu_p[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 15;
      if (logical_eq(is_nu, 1)) {
        current_statement__ = 13;
        nu = (nu_p[(1 - 1)] + 2);
      } else {
        current_statement__ = 11;
        nu = fixed_nu[(1 - 1)];
      }
      current_statement__ = 24;
      if (logical_eq(is_r, 1)) {
        current_statement__ = 20;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * rho[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 21;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - rho[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 22;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      } else {
        current_statement__ = 16;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * fixed_r[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 17;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt(
            (1 / (((2 * 1) / sigma2) * (1 - fixed_r[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 18;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      }
      current_statement__ = 25;
      assign(scale_i, cons_list(index_uni(1), nil_index_list()),
        (sigma_i[(1 - 1)] / stan::math::sqrt((nu / (nu - 2.0)))),
        "assigning variable scale_i");
      current_statement__ = 26;
      assign(scale_i, cons_list(index_uni(2), nil_index_list()),
        (sigma_i[(2 - 1)] / stan::math::sqrt((nu / (nu - 2.0)))),
        "assigning variable scale_i");
      current_statement__ = 27;
      pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                       N2, pstream__);
      current_statement__ = 34;
      if (logical_eq(is_d, 1)) {
        current_statement__ = 31;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 32;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      } else {
        current_statement__ = 28;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 29;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      }
      if (emit_transformed_parameters__) {
        vars__.emplace_back(pooled_sigma);
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(sigma_i[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(scale_i[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(mu_i[(sym1__ - 1)]);}
        vars__.emplace_back(nu);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double mu;
      mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      mu = context__.vals_r("mu")[(1 - 1)];
      double sigma2;
      sigma2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma2 = context__.vals_r("sigma2")[(1 - 1)];
      double sigma2_free__;
      sigma2_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma2_free__ = stan::math::lb_free(sigma2, 0);
      std::vector<double> delta;
      delta = std::vector<double>(is_d, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(delta, nil_index_list(), context__.vals_r("delta"),
        "assigning variable delta");
      std::vector<double> delta_free__;
      delta_free__ = std::vector<double>(is_d, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(delta[(sym1__ - 1)],
            coefs_lb(bounds_type_d, bounds_d, pstream__),
            coefs_ub(bounds_type_d, bounds_d, pstream__)),
          "assigning variable delta_free__");}
      std::vector<double> rho;
      rho = std::vector<double>(is_r, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(rho, nil_index_list(), context__.vals_r("rho"),
        "assigning variable rho");
      std::vector<double> rho_free__;
      rho_free__ = std::vector<double>(is_r, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(rho[(sym1__ - 1)],
            coefs_lb(bounds_type_r, bounds_r, pstream__),
            coefs_ub(bounds_type_r, bounds_r, pstream__)),
          "assigning variable rho_free__");}
      std::vector<double> nu_p;
      nu_p = std::vector<double>(is_nu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(nu_p, nil_index_list(), context__.vals_r("nu_p"),
        "assigning variable nu_p");
      std::vector<double> nu_p_free__;
      nu_p_free__ = std::vector<double>(is_nu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
        current_statement__ = 5;
        assign(nu_p_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(nu_p[(sym1__ - 1)],
            coefs_lb(bounds_type_nu, bounds_nu, pstream__),
            coefs_ub(bounds_type_nu, bounds_nu, pstream__)),
          "assigning variable nu_p_free__");}
      vars__.emplace_back(mu);
      vars__.emplace_back(sigma2_free__);
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        vars__.emplace_back(delta_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        vars__.emplace_back(rho_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
        vars__.emplace_back(nu_p_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("mu");
    names__.emplace_back("sigma2");
    names__.emplace_back("delta");
    names__.emplace_back("rho");
    names__.emplace_back("nu_p");
    names__.emplace_back("pooled_sigma");
    names__.emplace_back("sigma_i");
    names__.emplace_back("scale_i");
    names__.emplace_back("mu_i");
    names__.emplace_back("nu");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(is_d)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(is_r)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(is_nu)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma2");
    for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rho" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "nu_p" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "pooled_sigma");
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "scale_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu_i" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "nu");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma2");
    for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rho" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= is_nu; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "nu_p" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "pooled_sigma");
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "scale_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu_i" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "nu");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"array\",\"length\":" << is_d << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"array\",\"length\":" << is_r << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"nu_p\",\"type\":{\"name\":\"array\",\"length\":" << is_nu << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"pooled_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_i\",\"type\":{\"name\":\"array\",\"length\":" << 2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"scale_i\",\"type\":{\"name\":\"array\",\"length\":" << 2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"mu_i\",\"type\":{\"name\":\"array\",\"length\":" << 2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"array\",\"length\":" << is_d << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"array\",\"length\":" << is_r << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"nu_p\",\"type\":{\"name\":\"array\",\"length\":" << is_nu << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"pooled_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_i\",\"type\":{\"name\":\"array\",\"length\":" << 2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"scale_i\",\"type\":{\"name\":\"array\",\"length\":" << 2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"mu_i\",\"type\":{\"name\":\"array\",\"length\":" << 2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_t_namespace::model_t;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_t_namespace::profiles__;
}
#endif
#endif
