% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiles.R
\name{downloadNlTiles}
\alias{downloadNlTiles}
\title{Download the listed tiles for a given nlType in a given nlPeriod}
\usage{
downloadNlTiles(nlType, nlPeriod, tileList)
}
\arguments{
\item{nlType}{character The nightlight type}

\item{nlPeriod}{character The nlPeriod to process in the appropriate 
format}

\item{tileList}{integer vector or character vector of digits containing 
valid tile numbers as obtained by tileName2Idx for VIIRS. Ignore for 
nlType=="OLS"}
}
\value{
TRUE/FALSE if the download was successful
}
\description{
Download the listed tiles for a given nlType in a given nlPeriod
}
\examples{
#download VIIRS tiles for "KEN" which are tiles 2 and 5 for the specified
    #time periods
\dontrun{
Rnightlights:::downloadNlTiles("VIIRS.M", "201401", c(2, 5))
}

#same as above but getting the tileList automatically
\dontrun{
Rnightlights:::downloadNlTiles(nlType="VIIRS.M", 
    nlPeriod="201401", 
    tileList=Rnightlights:::getCtryTileList(ctryCodes="KEN", 
        nlType="VIIRS.M")
)
}

#returns TRUE if the download was successful or tile is cached locally

}
