% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsolve_CG.R
\name{lsolve.cg}
\alias{lsolve.cg}
\title{Conjugate Gradient method}
\usage{
lsolve.cg(A, B, xinit = NA, reltol = 1e-05, maxiter = 10000,
  preconditioner = diag(ncol(A)), adjsym = TRUE, verbose = TRUE)
}
\arguments{
\item{A}{an \eqn{(m\times n)} dense or sparse matrix. See also \code{\link[Matrix]{sparseMatrix}}.}

\item{B}{a vector of length \eqn{m} or an \eqn{(m\times k)} matrix (dense or sparse) for solving \eqn{k} systems simultaneously.}

\item{xinit}{a length-\eqn{n} vector for initial starting point. \code{NA} to start from a random initial point near 0.}

\item{reltol}{tolerance level for stopping iterations.}

\item{maxiter}{maximum number of iterations allowed.}

\item{preconditioner}{an \eqn{(n\times n)} preconditioning matrix; default is an identity matrix.}

\item{adjsym}{a logical; \code{TRUE} to symmetrize the system by transforming the system into normal equation, \code{FALSE} otherwise.}

\item{verbose}{a logical; \code{TRUE} to show progress of computation.}
}
\value{
a named list containing \describe{
\item{x}{solution; a vector of length \eqn{n} or a matrix of size \eqn{(n\times k)}.}
\item{iter}{the number of iterations required.}
\item{errors}{a vector of errors for stopping criterion.}
}
}
\description{
Conjugate Gradient(CG) method is an iterative algorithm for solving a system of linear equations where the system
is symmetric and positive definite.
For a square matrix \eqn{A}, it is required to be symmetric and positive definite.
For an overdetermined system where \code{nrow(A)>ncol(A)},
it is automatically transformed to the normal equation. Underdetermined system -
\code{nrow(A)<ncol(A)} - is not supported. Preconditioning matrix \eqn{M}, in theory, should be symmetric and positive definite
with fast computability for inverse, though it is not limited until the solver level.
}
\examples{
## Overdetermined System
A = matrix(rnorm(10*5),nrow=10)
x = rnorm(5)
b = A\%*\%x

out1 = lsolve.sor(A,b,w=0.5)
out2 = lsolve.cg(A,b)
matout = cbind(matrix(x),out1$x, out2$x);
colnames(matout) = c("true x","SSOR result", "CG result")
print(matout)

}
\references{
\insertRef{hestenes_methods_1952}{Rlinsolve}
}
