/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.DataFile;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.LinkedNode;

class DataFileAppender {
    protected static final byte[] RESERVED_SPACE = new byte[21];
    protected static final int DEFAULT_MAX_BATCH_SIZE = 0x400000;
    protected final AsyncDataManager dataManager;
    protected final Map<WriteKey, WriteCommand> inflightWrites;
    protected final Object enqueueMutex = new Object(){};
    protected WriteBatch nextWriteBatch;
    protected boolean shutdown;
    protected IOException firstAsyncException;
    protected final CountDownLatch shutdownDone = new CountDownLatch(1);
    protected int maxWriteBatchSize = 0x400000;
    protected boolean running;
    private Thread thread;

    public DataFileAppender(AsyncDataManager dataManager) {
        this.dataManager = dataManager;
        this.inflightWrites = this.dataManager.getInflightWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        WriteBatch batch;
        int size = data.getLength() + 32;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, sync);
        DataFileAppender dataFileAppender = this;
        synchronized (dataFileAppender) {
            DataFile dataFile = this.dataManager.allocateLocation(location);
            if (!sync) {
                this.inflightWrites.put(new WriteKey(location), write);
            }
            batch = this.enqueue(dataFile, write);
        }
        location.setLatch(batch.latch);
        if (sync) {
            try {
                batch.latch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            IOException exception = batch.exception.get();
            if (exception != null) {
                throw exception;
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location storeItem(ByteSequence data, byte type, Runnable onComplete) throws IOException {
        WriteBatch batch;
        int size = data.getLength() + 32;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, onComplete);
        DataFileAppender dataFileAppender = this;
        synchronized (dataFileAppender) {
            DataFile dataFile = this.dataManager.allocateLocation(location);
            this.inflightWrites.put(new WriteKey(location), write);
            batch = this.enqueue(dataFile, write);
        }
        location.setLatch(batch.latch);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteBatch enqueue(DataFile dataFile, WriteCommand write) throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            WriteBatch rc = null;
            if (this.shutdown) {
                throw new IOException("Async Writter Thread Shutdown");
            }
            if (!this.running) {
                this.running = true;
                this.thread = new Thread(){

                    public void run() {
                        DataFileAppender.this.processQueue();
                    }
                };
                this.thread.setPriority(10);
                this.thread.setDaemon(true);
                this.thread.setName("ActiveMQ Data File Writer");
                this.thread.start();
                this.firstAsyncException = null;
            }
            if (this.firstAsyncException != null) {
                throw this.firstAsyncException;
            }
            if (this.nextWriteBatch == null) {
                rc = this.nextWriteBatch = new WriteBatch(dataFile, write);
                this.enqueueMutex.notify();
            } else if (this.nextWriteBatch.canAppend(dataFile, write)) {
                this.nextWriteBatch.append(write);
                rc = this.nextWriteBatch;
            } else {
                try {
                    while (this.nextWriteBatch != null) {
                        this.enqueueMutex.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                if (this.shutdown) {
                    throw new IOException("Async Writter Thread Shutdown");
                }
                rc = this.nextWriteBatch = new WriteBatch(dataFile, write);
                this.enqueueMutex.notify();
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.running) {
                    this.enqueueMutex.notifyAll();
                } else {
                    this.shutdownDone.countDown();
                }
            }
        }
        try {
            this.shutdownDone.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    /*
     * Exception decompiling
     */
    protected void processQueue() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class WriteCommand
    extends LinkedNode {
        public final Location location;
        public final ByteSequence data;
        final boolean sync;
        public final Runnable onComplete;

        public WriteCommand(Location location, ByteSequence data, boolean sync) {
            this.location = location;
            this.data = data;
            this.sync = sync;
            this.onComplete = null;
        }

        public WriteCommand(Location location, ByteSequence data, Runnable onComplete) {
            this.location = location;
            this.data = data;
            this.onComplete = onComplete;
            this.sync = false;
        }
    }

    public class WriteBatch {
        public final DataFile dataFile;
        public final WriteCommand first;
        public final CountDownLatch latch = new CountDownLatch(1);
        public int size;
        public AtomicReference<IOException> exception = new AtomicReference();

        public WriteBatch(DataFile dataFile, WriteCommand write) throws IOException {
            this.dataFile = dataFile;
            this.first = write;
            this.size += write.location.getSize();
        }

        public boolean canAppend(DataFile dataFile, WriteCommand write) {
            if (dataFile != this.dataFile) {
                return false;
            }
            return this.size + write.location.getSize() < DataFileAppender.this.maxWriteBatchSize;
        }

        public void append(WriteCommand write) throws IOException {
            this.first.getTailNode().linkAfter(write);
            this.size += write.location.getSize();
        }
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }
}

