% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_github_data.R
\name{loadCallcenterData}
\alias{loadCallcenterData}
\title{Load Callcenter Data from GitHub Repository}
\format{
a dataframe with 87,600 rows and 5 variables:
\describe{
  \item{calls}{number of calls in a 6-minute aggregated interval.}
  \item{u}{numeric vector indicating the aggregated interval.}
  \item{Date}{date and time of call count recording.}
  \item{Day}{weekday associated with Date.}
  \item{Month}{month associated with Date.}
}
}
\usage{
loadCallcenterData()
}
\description{
This function loads the Callcenter dataset from the Rfssa_dataset repository on GitHub
(https://github.com/haghbinh/dataset/Rfssa_dataset). By hosting datasets on GitHub rather than
including them in the Rfssa R package, storage space is conserved.
The Callcenter dataset represents a small call center for an anonymous bank. It provides precise call
timing data from January 1 to December 31, 1999. The data is aggregated into 6-minute intervals on each day.
}
\examples{
\dontrun{
loadCallcenterData()
str(callcenter)
}

}
\references{
\enumerate{
\item
Brown, L., Gans, N., Mandelbaum, A., Sakov, A., Shen, H., Zeltyn, S., & Zhao, L. (2005).
Statistical analysis of a telephone call center: A queueing-science perspective.
\emph{Journal of the American Statistical Association}, \strong{100}(469), 36-50.
\item
Shen, H., & Huang, J. Z. (2005).
Analysis of call center arrival data using singular value decomposition.
\emph{Applied Stochastic Models in Business and Industry}, \strong{21}(3), 251-263.
\item
Huang, J. Z., Shen, H., & Buja, A. (2008).
Functional principal components analysis via penalized rank one approximation.
\emph{Electronic Journal of Statistics}, \strong{2}, 678-695.
\item
Maadooliat, M., Huang, J. Z., & Hu, J. (2015).
Integrating data transformation in principal components analysis.
\emph{Journal of Computational and Graphical Statistics}, \strong{24}(1), 84-103.
}
}
\seealso{
\code{\link{Callcenter}}, \code{\link{funts}}
}
