% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fssaplot.R
\name{plot.fssa}
\alias{plot.fssa}
\title{Plot Functional Singular Spectrum Analysis Objects}
\usage{
\method{plot}{fssa}(
  x,
  d = length(x$values),
  idx = 1:d,
  idy = idx + 1,
  contrib = TRUE,
  groups = as.list(1:d),
  type = "values",
  vars = NULL,
  ylab = NA,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{fssa}}.}

\item{d}{An integer which is the number of elementary components in the plot.}

\item{idx}{A vector of indices of eigen elements to plot.}

\item{idy}{A second vector of indices of eigen elements to plot (for \code{type="paired"}).}

\item{contrib}{A logical where if the value is \code{TRUE} (the default), the contribution of the component to the total variance is displayed.}

\item{groups}{A list or vector of indices determines grouping used for the decomposition(for \code{type="wcor"}).}

\item{type}{The type of plot to be displayed where possible types are:
\itemize{
\item \code{"values"} plot the square-root of singular values (default)
\item \code{"paired"} plot the pairs of eigenfunction's coefficients (useful for the detection of periodic components)
\item \code{"wcor"} plot the W-correlation matrix for the reconstructed objects
\item \code{"vectors"} plot the eigenfunction's coefficients (useful for the detection of period length)
\item \code{"lcurves"} plot of the eigenfunctions (useful for the detection of period length)
\item \code{"lheats"} heatmap plot of the eigenfunctions which can be used for \code{\link{fts}} variables observed over one or two-dimensional domains (useful for the detection of meaningful patterns)
\item \code{"periodogram"} periodogram plot (useful for the detecting the frequencies of oscillations in functional data).
}}

\item{vars}{A numeric specifying the variable number (can be used in plotting MFSSA \code{"lheats"} or \code{"lcurves"}).}

\item{ylab}{The character vector of name of variables.}

\item{...}{Arguments to be passed to methods, such as graphical parameters.}
}
\description{
This is a plotting method for objects of class functional singular spectrum analysis (\code{\link{fssa}}). The method is designed to help the user make decisions
 on how to do the grouping stage of univariate or multivariate functional singular spectrum analysis.
}
\note{
See \code{\link{fssa}} examples.
}
\seealso{
\code{\link{fssa}}, \code{\link{plot.fts}}
}
