% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineTrace.R
\name{combineTraces}
\alias{combineTraces}
\title{Combine traces}
\usage{
combineTraces(traces, burnin = 0)
}
\arguments{
\item{traces}{(list of data frames; no default) Name of a list of data
frames, such as produced by readTrace().}

\item{burnin}{(single numeric value; default = 0.0) Fraction of generations
to discard (if value provided is between 0 and 1) or number of generations
to discard (if value provided is greater than 1) before combining the
samples.}
}
\value{
combineTraces() returns a list of data frames of length 1,
corresponding to the combination of the provided samples.
}
\description{
Combine traces into one trace file
}
\details{
Combines multiple traces from independent MCMC replicates
into one trace file.
}
\examples{

\donttest{

#' # download the example dataset to working directory
url_1 <-
"https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR_run_1.log"
dest_path_1 <- "primates_cytb_GTR_run_1.log"
download.file(url_1, dest_path_1)

url_2 <-
"https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR_run_2.log"
dest_path_2 <- "primates_cytb_GTR_run_2.log"
download.file(url_2, dest_path_2)

# to run on your own data, change this to the path to your data file
file_1 <- dest_path_1
file_2 <- dest_path_2

# read in the multiple trace files
multi_trace <- readTrace(path = c(file_1, file_2), burnin = 0.0)

# combine samples after discarding 10\% burnin
combined_trace <- combineTraces(trace = multi_trace,
                                burnin = 0.1)

# remove files
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_1, dest_path_2)
}


}
