% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{cm_test_k}
\alias{cm_test_k}
\alias{c_means}
\title{Test the proper clusters k for c_means}
\usage{
cm_test_k(otu_group, filter_var, fast = TRUE)

c_means(otu_group, k_num, filter_var)
}
\arguments{
\item{otu_group}{standardize data}

\item{filter_var}{filter the highest var}

\item{fast}{whether do the gap_stat?}

\item{k_num}{cluster number}
}
\value{
ggplot

ggplot
}
\description{
Test the proper clusters k for c_means

C-means cluster
}
\examples{
\donttest{
data(otutab, package = "pcutils")
pcutils::hebing(otutab, metadata$Group) -> otu_group
cm_test_k(otu_group, filter_var = 0.7)
cm_res <- c_means(otu_group, k_num = 3, filter_var = 0.7)
plot(cm_res, 0.8)
}
}
