/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.LazyFont;
import org.docx4j.fonts.fop.fonts.Typeface;
import org.docx4j.fonts.foray.font.format.Panose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalFont {
    protected static Logger log = LoggerFactory.getLogger(PhysicalFont.class);
    protected FontResolver fontResolver;
    protected boolean loadTypefaceFailed;
    protected Typeface typeface;
    private static boolean loggedWarningAlready = false;
    String name;
    private EmbedFontInfo embedFontInfo;
    String embeddedFile;
    Panose panose;

    PhysicalFont(String name, EmbedFontInfo embedFontInfo, FontResolver fontResolver) {
        block6: {
            block5: {
                this.fontResolver = null;
                this.loadTypefaceFailed = false;
                this.typeface = null;
                try {
                    if (embedFontInfo.getPostScriptName() == null) {
                        log.error("Not set!");
                    }
                }
                catch (Exception e1) {
                    if (loggedWarningAlready) break block5;
                    log.warn("Not using patched FOP; getPostScriptName() method missing.");
                    loggedWarningAlready = true;
                }
            }
            this.embedFontInfo = embedFontInfo;
            this.fontResolver = fontResolver;
            this.setName(name);
            this.setEmbeddedFile(embedFontInfo.getEmbedFile());
            try {
                this.setPanose(embedFontInfo.getPanose());
            }
            catch (Exception e) {
                if (loggedWarningAlready) break block6;
                log.warn("Not using patched FOP; getPanose() method missing.");
                loggedWarningAlready = true;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EmbedFontInfo getEmbedFontInfo() {
        return this.embedFontInfo;
    }

    public String getEmbeddedFile() {
        return this.embeddedFile;
    }

    public void setEmbeddedFile(String embeddedFile) {
        this.embeddedFile = embeddedFile;
    }

    public Panose getPanose() {
        return this.panose;
    }

    public void setPanose(Panose panose) {
        this.panose = panose;
    }

    public Typeface getTypeface() {
        LazyFont lazyFont = null;
        if (this.typeface == null && !this.loadTypefaceFailed) {
            lazyFont = new LazyFont(this.embedFontInfo, this.fontResolver);
            this.typeface = lazyFont.getRealFont();
            this.loadTypefaceFailed = this.typeface == null;
        }
        return this.typeface;
    }
}

