/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.util.Set;
import java.util.TreeSet;
import org.docx4j.convert.out.ConversionFeatures;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.preprocess.BookmarkMover;
import org.docx4j.convert.out.common.preprocess.Containerization;
import org.docx4j.convert.out.common.preprocess.ConversionSectionWrapperFactory;
import org.docx4j.convert.out.common.preprocess.DisablePageBreakOnFirstParagraph;
import org.docx4j.convert.out.common.preprocess.FieldsCombiner;
import org.docx4j.convert.out.common.preprocess.PageBreak;
import org.docx4j.convert.out.common.preprocess.PartialDeepCopy;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocess
implements ConversionFeatures {
    private static Logger log = LoggerFactory.getLogger(Preprocess.class);

    public static OpcPackage process(OpcPackage opcPackage, Set<String> features) throws Docx4JException {
        OpcPackage ret = opcPackage;
        Set<String> relationshipTypes = null;
        Preprocess.checkParams(opcPackage, features);
        relationshipTypes = Preprocess.createRelationshipTypes(features);
        if (features.contains("pp.common.deepcopy")) {
            ret = PartialDeepCopy.process(opcPackage, relationshipTypes);
            if (opcPackage instanceof WordprocessingMLPackage) {
                log.debug("Results of PP_COMMON_DEEP_COPY: " + ((WordprocessingMLPackage)opcPackage).getMainDocumentPart().getXML());
            }
        }
        return ret;
    }

    protected static Set<String> createRelationshipTypes(Set<String> features) {
        TreeSet<String> relationshipTypes = new TreeSet<String>();
        if (features.contains("pp.common.movebookmarks") || features.contains("pp.common.containerization") || features.contains("pp.common.combinefields")) {
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes");
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments");
        }
        if (features.contains("pp.common.movepagebreak")) {
            relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        }
        return relationshipTypes;
    }

    public static WordprocessingMLPackage process(WordprocessingMLPackage wmlPackage, Set<String> features) throws Docx4JException {
        WordprocessingMLPackage ret = (WordprocessingMLPackage)Preprocess.process((OpcPackage)wmlPackage, features);
        if (features.contains("pp.common.combinefields")) {
            log.debug("PP_COMMON_COMBINE_FIELDS");
            FieldsCombiner.process(ret);
        }
        if (features.contains("pp.common.movebookmarks")) {
            log.debug("PP_COMMON_MOVE_BOOKMARKS");
            BookmarkMover.process(ret);
        }
        if (features.contains("pp.common.movepagebreak")) {
            log.debug("PP_COMMON_MOVE_PAGEBREAK");
            PageBreak.process(ret);
        }
        if (features.contains("pp.common.containerization")) {
            log.debug("PP_COMMON_CONTAINERIZATION");
            Containerization.process(ret);
        }
        if (features.contains("pp.apachefop.disablepagebreakfirstparagraph")) {
            log.debug("PP_APACHEFOP_DISABLE_PAGEBREAK_FIRST_PARAGRAPH");
            DisablePageBreakOnFirstParagraph.process(ret);
        }
        log.debug("Results of preprocessing: " + wmlPackage.getMainDocumentPart().getXML());
        return ret;
    }

    public static ConversionSectionWrappers createWrappers(WordprocessingMLPackage wmlPackage, Set<String> features) throws Docx4JException {
        ConversionSectionWrappers ret = null;
        boolean dummySections = false;
        boolean dummyPageNumbering = false;
        Preprocess.checkParams(wmlPackage, features);
        dummySections = !features.contains("pp.common.createsections");
        dummyPageNumbering = !features.contains("pp.common.pagenumbering");
        ret = ConversionSectionWrapperFactory.process(wmlPackage, dummySections, dummyPageNumbering);
        return ret;
    }

    protected static void checkParams(OpcPackage opcPackage, Set<String> features) {
        if (opcPackage == null) {
            throw new IllegalArgumentException("The passed opcPackage is null.");
        }
        if (features == null) {
            throw new IllegalArgumentException("The set of the features is null.");
        }
        if (features.contains("pp.common.pagenumbering")) {
            features.add("pp.common.combinefields");
        }
        if (!features.contains("pp.common.pagenumbering")) {
            features.add("pp.common.dummypagenumbering");
        }
        if (!features.contains("pp.common.createsections")) {
            features.add("pp.common.dummycreatesections");
        }
    }
}

