/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLIndenter
extends DefaultHandler
implements ContentHandler {
    private final PrintWriter writer;
    private transient int indentLevel = 0;
    private transient Stack<Integer> states = new Stack();
    private static final Integer EMPTY = new Integer(0);
    private static final Integer HAS_TEXT = new Integer(1);
    private static final Integer HAS_CHILDREN = new Integer(2);

    private XMLIndenter(Writer w) {
        this.writer = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) {
        int i;
        if (!this.states.empty()) {
            if (this.states.pop().equals(EMPTY)) {
                this.writer.println('>');
            }
            this.states.push(HAS_CHILDREN);
        }
        for (i = 0; i < this.indentLevel; ++i) {
            this.writer.print("  ");
        }
        this.writer.print('<' + qName);
        for (i = 0; i < atts.getLength(); ++i) {
            this.writer.print(' ' + atts.getQName(i) + "=\"" + atts.getValue(i) + '\"');
        }
        ++this.indentLevel;
        this.states.push(EMPTY);
    }

    public void endElement(String uri, String localName, String qName) {
        --this.indentLevel;
        Integer state = this.states.pop();
        if (EMPTY.equals(state)) {
            this.writer.println("/>");
        } else if (HAS_TEXT.equals(state)) {
            this.writer.println("</" + qName + '>');
        } else if (HAS_CHILDREN.equals(state)) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.print("  ");
            }
            this.writer.println("</" + qName + '>');
        }
    }

    public void characters(char[] ch, int position, int offset) {
        if (this.states.peek().equals(EMPTY)) {
            this.states.pop();
            this.writer.print('>');
            this.states.push(HAS_TEXT);
        }
        this.writer.print(new String(ch, position, offset));
    }

    public void ignorableWhitespace(char[] ch, int position, int offset) {
    }

    public static String indent(String xml) throws SAXException, IOException, ParserConfigurationException {
        StringWriter writer = new StringWriter();
        StringReader reader = new StringReader(xml);
        XMLIndenter.indent(reader, writer);
        return ((Object)writer).toString();
    }

    public static void indent(Reader r, Writer w) throws SAXException, IOException, ParserConfigurationException {
        XMLIndenter indenter = new XMLIndenter(w);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        InputSource source = new InputSource(r);
        XMLReader xmlreader = factory.newSAXParser().getXMLReader();
        xmlreader.setContentHandler(indenter);
        xmlreader.parse(source);
    }

    public static String indentSilent(String xml) {
        try {
            return XMLIndenter.indent(xml);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean indentSilent(Reader r, Writer w) {
        try {
            XMLIndenter.indent(r, w);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

