% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRScript.R
\name{addRScript}
\alias{addRScript}
\alias{addRScript.bsdoc}
\alias{addRScript.docx}
\alias{addRScript.pptx}
\title{Add R script into a document object}
\usage{
addRScript(doc, rscript, file, text, ...)

\method{addRScript}{docx}(doc, rscript, file, text, bookmark,
  par.properties = parProperties(), ...)

\method{addRScript}{pptx}(doc, rscript, file, text, append = FALSE, ...)

\method{addRScript}{bsdoc}(doc, rscript, file, text, ...)
}
\arguments{
\item{doc}{document object}

\item{rscript}{an object of class \code{RScript}.
Not used if file or text is provided.}

\item{file}{R script file. Not used if text or
rscript is provided.}

\item{text}{character vector. The text to parse.
Not used if file or rscript is provided.}

\item{...}{further arguments passed to other methods}

\item{bookmark}{a character value ; id of the Word bookmark to
replace by the script. optional. See \code{\link{bookmark}}.}

\item{par.properties}{paragraph formatting properties of the
paragraphs that contain rscript. An object of class \code{\link{parProperties}}}

\item{append}{boolean default to FALSE. If TRUE, paragraphs will be
appened in the current shape instead of beeing sent into a new shape.
Paragraphs can only be appended on shape containing paragraphs (i.e. you
can not add paragraphs after a FlexTable).}
}
\value{
a document object
}
\description{
Add R script into a document object
}
\details{
You have to one of the following argument: file or text or rscript.
}
\examples{

# docx example -----------
doc.filename = "ex_rscript.docx"

options( "ReporteRs-fontsize" = 10 )
doc <- docx( )
doc = addRScript(doc, text = "x = rnorm(100)
plot(density( x ) )" )

writeDoc( doc, file = doc.filename )

# pptx example -----------
doc.filename = "ex_rscript.pptx"

options( "ReporteRs-fontsize" = 24 )
doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )
doc = addRScript(doc, text = "x = rnorm(100)
plot(density( x ) )" )

writeDoc( doc, file = doc.filename )

# bsdoc example -----------
doc.filename = "ex_rscript/example.html"

options( "ReporteRs-fontsize" = 11 )
doc = bsdoc( )
doc = addRScript(doc, text = "x = rnorm(100)
plot(density( x ) )" )

writeDoc( doc, file = doc.filename )
}
\seealso{
\code{\link{bsdoc}}, \code{\link{docx}}, \code{\link{pptx}}
}

