/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.util.LinkedHashMap;
import org.lysis.reporters.formats.BorderProperties;
import org.lysis.reporters.formats.CellProperties;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.tables.FlexCell;
import org.lysis.reporters.tables.FlexRow;
import org.lysis.reporters.text.Paragraph;
import org.lysis.reporters.tools.Debug;

public class MetaRows {
    private LinkedHashMap<Integer, FlexRow> flexrowsList = new LinkedHashMap();
    private int nrows = 0;

    public void add(FlexRow fr) {
        this.flexrowsList.put(this.nrows, fr);
        ++this.nrows;
    }

    public void insert(FlexRow fr) {
        LinkedHashMap<Integer, FlexRow> newflexrowsList = new LinkedHashMap<Integer, FlexRow>();
        newflexrowsList.put(0, fr);
        int i = 0;
        while (i < this.nrows) {
            newflexrowsList.put(i + 1, this.flexrowsList.get(i));
            ++i;
        }
        this.flexrowsList = newflexrowsList;
        ++this.nrows;
    }

    public LinkedHashMap<Integer, FlexRow> get() {
        return this.flexrowsList;
    }

    public FlexRow get(int i) {
        return this.flexrowsList.get(i);
    }

    public void reset() {
        this.flexrowsList.clear();
        this.nrows = 0;
    }

    private void add(int i, int j, String par, TextProperties tp, boolean newPar) throws Exception {
        if (this.nrows < 1) {
            return;
        }
        if (i > this.nrows - 1) {
            return;
        }
        if (!this.flexrowsList.containsKey(i)) {
            return;
        }
        FlexRow fr = this.flexrowsList.get(i);
        if (!fr.hasCell(j)) {
            return;
        }
        int col_id = fr.getCellIDCellAt(j);
        if (Debug.debug) {
            System.err.println("col_id: " + col_id);
        }
        if (col_id < 0) {
            return;
        }
        if (Debug.debug) {
            System.err.println("set at:" + i + " col_id:" + col_id);
        }
        FlexCell fc = fr.getCell(col_id);
        if (newPar) {
            Paragraph p = new Paragraph();
            p.addText(par, tp.getClone());
            fc.getParagraphsSection().addParagraph(p);
        } else {
            Paragraph p = fc.getParagraphsSection().getLast();
            p.addText(par, tp.getClone());
        }
    }

    public void add(int[] i, int[] j, String[] par, TextProperties tp, boolean newPar) throws Exception {
        if (this.nrows < 1) {
            return;
        }
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.add(i[row], j[col], par[row * lj + col], tp, newPar);
                ++col;
            }
            ++row;
        }
    }

    private void add(int i, int j, Paragraph par, boolean newPar) throws Exception {
        if (this.nrows < 1) {
            return;
        }
        if (i > this.nrows - 1) {
            return;
        }
        if (!this.flexrowsList.containsKey(i)) {
            return;
        }
        FlexRow fr = this.flexrowsList.get(i);
        int col_id = fr.getCellIDCellAt(j);
        if (Debug.debug) {
            System.err.println("col_id: " + col_id);
        }
        if (col_id < 0) {
            return;
        }
        if (Debug.debug) {
            System.err.println("set at:" + i + " col_id:" + col_id);
        }
        FlexCell fc = fr.getCell(col_id);
        if (newPar) {
            fc.getParagraphsSection().addParagraph(par);
        } else {
            fc.getParagraphsSection().getLast().addParagraph(par);
        }
    }

    public void add(int[] i, int[] j, Paragraph par, boolean newPar) throws Exception {
        if (this.nrows < 1) {
            return;
        }
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.add(i[row], j[col], par, newPar);
                ++col;
            }
            ++row;
        }
    }

    public void setBorderGrid(BorderProperties inner_v, BorderProperties inner_h, BorderProperties outer_v, BorderProperties outer_h) {
        if (this.nrows < 1) {
            return;
        }
        int i = 0;
        while (i < this.nrows) {
            FlexRow workingRow = this.flexrowsList.get(i);
            int ncol = workingRow.size();
            if (ncol > 0) {
                int j = 0;
                while (j < ncol) {
                    FlexCell fc = workingRow.getCell(j);
                    if (i == 0) {
                        fc.setBorderTop(outer_h);
                    } else {
                        fc.setBorderTop(inner_h);
                    }
                    if (i == this.nrows - 1) {
                        fc.setBorderBottom(outer_h);
                    } else {
                        fc.setBorderBottom(inner_h);
                    }
                    if (j == 0) {
                        fc.setBorderLeft(outer_v);
                    } else {
                        fc.setBorderLeft(inner_v);
                    }
                    if (j == ncol - 1) {
                        fc.setBorderRight(outer_v);
                    } else {
                        fc.setBorderRight(inner_v);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public int getColspan(int i, int j) {
        if (!this.flexrowsList.containsKey(i)) {
            return -1;
        }
        FlexRow temp = this.flexrowsList.get(i);
        if (!temp.hasCell(j)) {
            return -2;
        }
        return temp.getCell(j).getColspan();
    }

    public void set(int[] i, int[] j, BorderProperties properties, String side) {
        if (this.nrows < 1) {
            return;
        }
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.set(i[row], j[col], properties, side);
                ++col;
            }
            ++row;
        }
    }

    public void set(int i, int j, BorderProperties properties, String side) {
        if (Debug.debug) {
            System.err.println("set BorderProperties i:" + i + " j:" + j);
        }
        if (this.nrows < 1) {
            return;
        }
        if (i > this.nrows - 1) {
            return;
        }
        if (!this.flexrowsList.containsKey(i)) {
            return;
        }
        FlexRow fr = this.flexrowsList.get(i);
        int col_id = fr.getCellIDCellAt(j);
        if (Debug.debug) {
            System.err.println("col_id: " + col_id);
        }
        if (col_id < 0) {
            return;
        }
        if (Debug.debug) {
            System.err.println("set at:" + i + " col_id:" + col_id);
        }
        FlexCell fc = fr.getCell(col_id);
        if (side.equals("top")) {
            fc.setBorderTop(properties);
        } else if (side.equals("bottom")) {
            fc.setBorderBottom(properties);
        } else if (side.equals("left")) {
            fc.setBorderLeft(properties);
        } else if (side.equals("right")) {
            fc.setBorderRight(properties);
        }
        if (side.equals("top")) {
            if (!this.flexrowsList.containsKey(i - 1)) {
                return;
            }
            FlexRow frprev = this.flexrowsList.get(i - 1);
            if (!frprev.hasCellAt(j)) {
                return;
            }
            col_id = frprev.getCellIDCellAt(j);
            fc = frprev.getCell(col_id);
            fc.setBorderBottom(properties);
        } else if (side.equals("bottom")) {
            if (!this.flexrowsList.containsKey(i + 1)) {
                return;
            }
            FlexRow frnext = this.flexrowsList.get(i + 1);
            if (!frnext.hasCell(col_id = frnext.getCellIDCellAt(j))) {
                return;
            }
            fc = frnext.getCell(col_id);
            fc.setBorderTop(properties);
        } else if (side.equals("left")) {
            if (!fr.hasCell(col_id - 1)) {
                return;
            }
            fc = fr.getCell(col_id - 1);
            fc.setBorderRight(properties);
        } else if (side.equals("right")) {
            if (!fr.hasCell(col_id + 1)) {
                return;
            }
            fc = fr.getCell(col_id + 1);
            fc.setBorderLeft(properties);
        }
    }

    public void set(int[] i, int[] j, CellProperties cp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.set(i[row], j[col], cp);
                ++col;
            }
            ++row;
        }
    }

    public void setBackgroundColors(int[] i, int[] j, String[] colors) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.setBackgroundColor(i[row], j[col], colors[row * lj + col]);
                ++col;
            }
            ++row;
        }
    }

    public void setBackgroundColor(int i, int j, String color) {
        if (this.nrows < 1) {
            return;
        }
        if (i > this.nrows - 1) {
            return;
        }
        if (!this.flexrowsList.containsKey(i)) {
            return;
        }
        FlexRow fr = this.flexrowsList.get(i);
        int col_id = fr.getCellIDCellAt(j);
        if (Debug.debug) {
            System.err.println("col_id: " + col_id);
        }
        if (col_id < 0) {
            return;
        }
        if (Debug.debug) {
            System.err.println("set at:" + i + " col_id:" + col_id);
        }
        FlexCell fc = fr.getCell(col_id);
        fc.getCellProperties().setBackgroundColor(color);
    }

    public void set(int i, int j, CellProperties properties) {
        if (this.nrows < 1) {
            return;
        }
        if (i > this.nrows - 1) {
            return;
        }
        if (!this.flexrowsList.containsKey(i)) {
            return;
        }
        FlexRow fr = this.flexrowsList.get(i);
        int col_id = fr.getCellIDCellAt(j);
        if (Debug.debug) {
            System.err.println("col_id: " + col_id);
        }
        if (col_id < 0) {
            return;
        }
        if (Debug.debug) {
            System.err.println("set at:" + i + " col_id:" + col_id);
        }
        FlexCell fc = fr.getCell(col_id);
        fc.setCellProperties(properties.getClone());
    }

    public void set(int[] i, int[] j, ParProperties pp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.set(i[row], j[col], pp);
                ++col;
            }
            ++row;
        }
    }

    public void set(int i, int j, ParProperties properties) {
        if (this.nrows < 1) {
            return;
        }
        if (i > this.nrows - 1) {
            return;
        }
        if (!this.flexrowsList.containsKey(i)) {
            return;
        }
        FlexRow fr = this.flexrowsList.get(i);
        int col_id = fr.getCellIDCellAt(j);
        if (Debug.debug) {
            System.err.println("col_id: " + col_id);
        }
        if (col_id < 0) {
            return;
        }
        if (Debug.debug) {
            System.err.println("set at:" + i + " col_id:" + col_id);
        }
        FlexCell fc = fr.getCell(col_id);
        fc.setParProperties(properties.getClone());
    }

    public void set(int[] i, int[] j, TextProperties tp) {
        int li = i.length;
        int lj = j.length;
        int row = 0;
        while (row < li) {
            int col = 0;
            while (col < lj) {
                this.set(i[row], j[col], tp);
                ++col;
            }
            ++row;
        }
    }

    public void set(int i, int j, TextProperties properties) {
        if (this.nrows < 1) {
            return;
        }
        if (i > this.nrows - 1) {
            return;
        }
        if (!this.flexrowsList.containsKey(i)) {
            return;
        }
        FlexRow fr = this.flexrowsList.get(i);
        int col_id = fr.getCellIDCellAt(j);
        if (Debug.debug) {
            System.err.println("col_id: " + col_id);
        }
        if (col_id < 0) {
            return;
        }
        if (Debug.debug) {
            System.err.println("set at:" + i + " col_id:" + col_id);
        }
        FlexCell fc = fr.getCell(col_id);
        fc.setTextProperties(properties.getClone());
    }

    public int size() {
        return this.nrows;
    }
}

