/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements;

import java.util.LinkedHashMap;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.html4r.elements.Title;
import org.lysis.reporters.html4r.tools.Tree;

public class TOC
implements HTML4R {
    private LinkedHashMap<Integer, Title> titles = new LinkedHashMap();
    private int titleIndex = -1;
    private Tree<Title> tree;
    private Title currentContainer;
    private int currentLevel = 0;

    public TOC(String headStr) {
        Title root = new Title(headStr, 0);
        this.tree = new Tree<Title>(root);
        this.currentContainer = root;
    }

    public void addTitle(Title title) {
        ++this.titleIndex;
        this.titles.put(this.titleIndex, title);
        if (title.getLevel() > this.currentLevel) {
            this.tree.addLeaf(this.currentContainer, title);
        } else if (title.getLevel() == this.currentLevel) {
            this.tree.getTree(this.currentContainer).getParent().addLeaf(title);
        } else if (title.getLevel() < this.currentLevel) {
            this.tree.getTree(this.currentContainer).getParent().getParent().addLeaf(title);
        }
        this.currentContainer = title;
        this.currentLevel = title.getLevel();
    }

    @Override
    public String getHTML() {
        String out = "";
        out = String.valueOf(out) + "<div class=\"navbar-fixed-topleft nav nav-list bs-sidebar\" role=\"navigation\">";
        out = String.valueOf(out) + this.tree.Tree2HTML();
        out = String.valueOf(out) + "</div>";
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        String str = "var $window = $(window)\nvar $body   = $(document.body)\nvar navHeight = $('.navbar').outerHeight(true) + 10\n$body.scrollspy({\n\ttarget: '.bs-sidebar',\n\toffset: navHeight\n})\n$window.on('load', function () {\n\t$body.scrollspy('refresh')\n})\n$('.bs-docs-container [href=#]').click(function (e) {\n\te.preventDefault()\n})\nsetTimeout(function () {\n\tvar $sideBar = $('.bs-sidebar')\n$sideBar.affix({\n\toffset: {\n\ttop: function () {\n\t\tvar offsetTop\t  = $sideBar.offset().top\n\t\tvar sideBarMargin  = parseInt($sideBar.children(0).css('margin-top'), 10)\n\t\tvar navOuterHeight = $('.bs-docs-nav').height()\n\t\treturn (this.top = offsetTop - navOuterHeight - sideBarMargin)\n\t\t}\t, bottom: function () {\n\t\treturn (this.bottom = $('.bs-footer').outerHeight(true))\n\t\t}\n\t}\n\t})\n}, 100)\nsetTimeout(function () {\n\t$('.bs-top').affix()\n}, 100)\n";
        return str;
    }

    @Override
    public boolean hasJS() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }
}

