% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series_ties.R
\name{series_ties}
\alias{series_ties}
\title{Summary of Record Ties}
\usage{
series_ties(X, record = c("upper", "lower"))
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record to be 
assessed, "upper" or "lower".}
}
\value{
A \code{list} object with elements:
  \item{number}{Number of records: A vector containing the observed total, 
    strong and weak number of records and the expected under IID.}
  \item{percentage}{\% of weak records: Percentage of weak records within
    the total.}
  \item{percentage.position}{\% of weak records by position: A vector with
    the percentage of weak records with \code{names} corresponding to its
    observed instant.}
}
\description{
This function compares the number of strog and weak records
  to quantify whether rounding effects could greatly skew the conclusions.
}
\details{
This function is used in the data preparation (or pre-processing) 
  often required to apply the exploratory and inference tools based on 
  theory of records within this package.
 
 The theory of records on which the hypothesis tests are based assumes 
 that the random variables are continuous, proving that the probability 
 that two observations take the same value is zero. Most of the data 
 collected is rounded, giving a certain probability to the tie between 
 records, thereby reducing the number of new records(see, e.g., Wergen 
 et al. 2012). 
 
 This function summarises the difference between the number of observed 
 strong records and the weak records.
}
\examples{
series_ties(ZaragozaSeries)

}
\references{
Wergen G, Volovik D, Redner S, Krug J (2012). 
“Rounding Effects in Record Statistics.”
\emph{Physical Review Letters}, \strong{109}(16), 164102.
}
\seealso{
\code{\link{series_double}}, \code{\link{series_record}}, 
  \code{\link{series_rev}}, \code{\link{series_split}}, 
  \code{\link{series_uncor}}, \code{\link{series_untie}}
}
\author{
Jorge Castillo-Mateo
}
