% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_LLE.R
\name{do.lle}
\alias{do.lle}
\title{Locally Linear Embedding}
\usage{
do.lle(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = "union",
  weight = TRUE,
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten"),
  regtype = FALSE,
  regparam = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}.
See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform LLE on weighted graph, or \code{FALSE} otherwise.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{regtype}{\code{TRUE} for automatic regularization parameter selection, \code{FALSE} otherwise as default.}

\item{regparam}{regularization parameter.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{eigvals}{a vector of eigenvalues from computation of embedding matrix.}
}
}
\description{
Locally-Linear Embedding (LLE) was introduced approximately at the same time as Isomap.
Its idea was motivated to describe entire data manifold by making a chain of local patches
in that low-dimensional embedding should resemble the connectivity pattern of patches.
\code{do.lle} also provides an automatic choice of regularization parameter based on an
optimality criterion suggested by authors.
}
\examples{
\donttest{
## generate swiss-roll data
set.seed(100)
X = aux.gensamples(n=100)

## 1. connecting 10\% of data for graph construction.
output1 <- do.lle(X,ndim=2,type=c("proportion",0.10))

## 2. constructing 20\%-connected graph
output2 <- do.lle(X,ndim=2,type=c("proportion",0.20))

## 3. constructing 50\%-connected with bigger regularization parameter
output3 <- do.lle(X,ndim=2,type=c("proportion",0.5),regparam=10)

## Visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, main="5\%")
plot(output2$Y, main="10\%")
plot(output3$Y, main="50\%+Binary")
par(opar)
}

}
\references{
\insertRef{roweis_nonlinear_2000}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
