% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ONPP.R
\name{do.onpp}
\alias{do.onpp}
\title{Orthogonal Neighborhood Preserving Projections}
\usage{
do.onpp(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Orthogonal Neighborhood Preserving Projection (ONPP) is an unsupervised linear dimension reduction method.
It constructs a weighted data graph from LLE method. Also, it develops LPP method by preserving
the structure of local neighborhoods.
}
\examples{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## try different numbers for neighborhood size
out1 = do.onpp(X, type=c("proportion",0.10))
out2 = do.onpp(X, type=c("proportion",0.25))
out3 = do.onpp(X, type=c("proportion",0.50))

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=label, main="ONPP::10\% connectivity")
plot(out2$Y, pch=19, col=label, main="ONPP::25\% connectivity")
plot(out3$Y, pch=19, col=label, main="ONPP::50\% connectivity")
par(opar)

}
\references{
\insertRef{kokiopoulou_orthogonal_2007}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
