% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ELDE.R
\name{do.elde}
\alias{do.elde}
\title{Exponential Local Discriminant Embedding}
\usage{
do.elde(X, label, ndim = 2, t = 1, preprocess = c("center", "decorrelate",
  "whiten"), k1 = max(ceiling(nrow(X)/10), 2), k2 = max(ceiling(nrow(X)/10),
  2))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{t}{kernel bandwidth in \eqn{(0,\infty)}.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{k1}{the number of same-class neighboring points (homogeneous neighbors).}

\item{k2}{the number of different-class neighboring points (heterogeneous neighbors).}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Local Discriminant Embedding (LDE) suffers from a small-sample-size problem where
scatter matrix may suffer from rank deficiency. Exponential LDE (ELDE) provides
not only a remedy for the problem using matrix exponential, but also a flexible
framework to transform original data into a new space via distance diffusion mapping
similar to kernel-based nonlinear mapping.
}
\examples{
## generate data of 3 types with difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## try different kernel bandwidth
out1 = do.elde(X, label, t=1)
out2 = do.elde(X, label, t=25)
out3 = do.elde(X, label, t=Inf)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="ELDE::bandwidth=1")
plot(out2$Y[,1], out2$Y[,2], main="ELDE::bandwidth=25")
plot(out3$Y[,1], out3$Y[,2], main="ELDE::bandwidth=Infty")

}
\references{
\insertRef{dornaika_exponential_2013}{Rdimtools}
}
\seealso{
\code{\link{do.lde}}
}
\author{
Kisung You
}
